<?php

require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'AdminMyVetShopAppVetzenMaintenanceController.php';

class MyvetshopcliniqueAppCheckVersionVetzenModuleFrontController extends FrontController
{
    /**
     *  Vérifie la version de l'application
     */
    public function initContent(): void
    {
        parent::initContent();

        $response = [];

        try {
            $appVersion = Tools::getValue('version');

            if ('GET' === $_SERVER['REQUEST_METHOD']) {
                if ($appVersion) {
                    http_response_code(200);

                    $minVerison = (string) Configuration::get(AdminMyVetShopAppVetzenMaintenanceController::PREFIX_NAME_COMFIG . 'MIN_VERSION');
                    // Si aucune version demandée dans l'admin, alors on indique que la version mini est celle fournie par l'app
                    if (!$minVerison) {
                        $minVerison = $appVersion;
                    }

                    $response
                        = [
                            'minVersion' => $minVerison,
                            'versionIsValid' => -1 !== version_compare((string) $appVersion, $minVerison),
                            //-1 si la première version est inférieure à la seconde, 0 si elles sont égales, et 1 si la seconde est inférieure à la première.
                        ];
                } else {
                    http_response_code(400);
                    $response = [
                        'error' => 'version envoyée invalide',
                        'version' => $appVersion,
                    ];
                }
            } else {
                http_response_code(400);
            }
        } catch (Exception $exception) {
            http_response_code(500);
            $response = ['error' => $exception->getMessage()];
        }

        header('Content-Type: application/json');
        echo json_encode($response);
        exit();
    }
}
