<?php

namespace NoahVet\Reef\Iam\Endpoint;

class PutClientItemDefinition extends \NoahVet\Reef\Iam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Iam\Runtime\Client\Endpoint
{
    protected $slug;
    /**
     * Update client resources types and allowed permissions
     *
     * @param string $slug Resource identifier
     * @param \NoahVet\Reef\Iam\Model\ServiceDefinition $requestBody 
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     */
    public function __construct(string $slug, \NoahVet\Reef\Iam\Model\ServiceDefinition $requestBody, array $headerParameters = [])
    {
        $this->slug = $slug;
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Iam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'PUT';
    }
    public function getUri() : string
    {
        return str_replace(['{slug}'], [$this->slug], '/api/clients/{slug}/definition');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Iam\Model\ServiceDefinition) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['X-Reef-Client-ID', 'X-Reef-Client-HMAC']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('X-Reef-Client-ID', ['string']);
        $optionsResolver->addAllowedTypes('X-Reef-Client-HMAC', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Iam\Exception\PutClientItemDefinitionBadRequestException
     * @throws \NoahVet\Reef\Iam\Exception\PutClientItemDefinitionNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\PutClientItemDefinitionUnprocessableEntityException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\ServiceDefinition
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Iam\\Model\\ServiceDefinition', 'json');
        }
        if (is_null($contentType) === false && (304 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Iam\\Model\\ServiceDefinition', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Iam\Exception\PutClientItemDefinitionBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Iam\Exception\PutClientItemDefinitionNotFoundException($response);
        }
        if (422 === $status) {
            throw new \NoahVet\Reef\Iam\Exception\PutClientItemDefinitionUnprocessableEntityException($response);
        }
        throw new \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}