<?php

namespace NoahVet\Reef\Iam\Model;

class ServiceResource extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * 
     *
     * @var string
     */
    protected $name;
    /**
     * 
     *
     * @var string
     */
    protected $description;
    /**
     * 
     *
     * @var string
     */
    protected $groupSlug;
    /**
     * 
     *
     * @var array<string, ServicePermission>
     */
    protected $permissions;
    /**
     * 
     *
     * @return string
     */
    public function getName() : string
    {
        return $this->name;
    }
    /**
     * 
     *
     * @param string $name
     *
     * @return self
     */
    public function setName(string $name) : self
    {
        $this->initialized['name'] = true;
        $this->name = $name;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getDescription() : string
    {
        return $this->description;
    }
    /**
     * 
     *
     * @param string $description
     *
     * @return self
     */
    public function setDescription(string $description) : self
    {
        $this->initialized['description'] = true;
        $this->description = $description;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getGroupSlug() : string
    {
        return $this->groupSlug;
    }
    /**
     * 
     *
     * @param string $groupSlug
     *
     * @return self
     */
    public function setGroupSlug(string $groupSlug) : self
    {
        $this->initialized['groupSlug'] = true;
        $this->groupSlug = $groupSlug;
        return $this;
    }
    /**
     * 
     *
     * @return array<string, ServicePermission>
     */
    public function getPermissions() : iterable
    {
        return $this->permissions;
    }
    /**
     * 
     *
     * @param array<string, ServicePermission> $permissions
     *
     * @return self
     */
    public function setPermissions(iterable $permissions) : self
    {
        $this->initialized['permissions'] = true;
        $this->permissions = $permissions;
        return $this;
    }
}