<?php

namespace NoahVet\Reef\Iam\Model;

class GrantedPermissionShort extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Resource or ResourceGroup slug
     *
     * @var string
     */
    protected $resource;
    /**
     * Permission or PermissionGroup slug
     *
     * @var string
     */
    protected $permission;
    /**
     * Permission or PermissionGroup slug
     *
     * @var string
     */
    protected $principal;
    /**
     * 1 to allow the permission, -1 to deny the permission
     *
     * @var int
     */
    protected $grantType;
    /**
     * Resource or ResourceGroup slug
     *
     * @return string
     */
    public function getResource() : string
    {
        return $this->resource;
    }
    /**
     * Resource or ResourceGroup slug
     *
     * @param string $resource
     *
     * @return self
     */
    public function setResource(string $resource) : self
    {
        $this->initialized['resource'] = true;
        $this->resource = $resource;
        return $this;
    }
    /**
     * Permission or PermissionGroup slug
     *
     * @return string
     */
    public function getPermission() : string
    {
        return $this->permission;
    }
    /**
     * Permission or PermissionGroup slug
     *
     * @param string $permission
     *
     * @return self
     */
    public function setPermission(string $permission) : self
    {
        $this->initialized['permission'] = true;
        $this->permission = $permission;
        return $this;
    }
    /**
     * Permission or PermissionGroup slug
     *
     * @return string
     */
    public function getPrincipal() : string
    {
        return $this->principal;
    }
    /**
     * Permission or PermissionGroup slug
     *
     * @param string $principal
     *
     * @return self
     */
    public function setPrincipal(string $principal) : self
    {
        $this->initialized['principal'] = true;
        $this->principal = $principal;
        return $this;
    }
    /**
     * 1 to allow the permission, -1 to deny the permission
     *
     * @return int
     */
    public function getGrantType() : int
    {
        return $this->grantType;
    }
    /**
     * 1 to allow the permission, -1 to deny the permission
     *
     * @param int $grantType
     *
     * @return self
     */
    public function setGrantType(int $grantType) : self
    {
        $this->initialized['grantType'] = true;
        $this->grantType = $grantType;
        return $this;
    }
}