<?php

namespace NoahVet\Reef\Iam\Endpoint;

class GetResourceCollectionPermissions extends \NoahVet\Reef\Iam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Iam\Runtime\Client\Endpoint
{
    protected $slug;
    /**
     * Retrieve effective permissions on a collection of resources
     *
     * @param string $slug Resource identifier
     * @param array $queryParameters {
     *     @var array $slug[] List of resources you want permissions for
     *     @var string $principal Principal ID (if different from the one doing the query)
     *     @var int $page The collection page number
     *     @var int $itemsPerPage The number of items per page
     * }
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     */
    public function __construct(string $slug, array $queryParameters = [], array $headerParameters = [])
    {
        $this->slug = $slug;
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Iam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return str_replace(['{slug}'], [$this->slug], '/api/resources/permissions');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getQueryOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['slug', 'principal', 'page', 'itemsPerPage']);
        $optionsResolver->setRequired(['slug']);
        $optionsResolver->setDefaults(['page' => 1, 'itemsPerPage' => 30]);
        $optionsResolver->addAllowedTypes('slug', ['array']);
        $optionsResolver->addAllowedTypes('principal', ['string']);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('itemsPerPage', ['int']);
        return $optionsResolver;
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['X-Reef-Client-ID', 'X-Reef-Client-HMAC']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('X-Reef-Client-ID', ['string']);
        $optionsResolver->addAllowedTypes('X-Reef-Client-HMAC', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PermissionGrantList
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Iam\\Model\\PermissionGrantList', 'json');
        }
        throw new \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}