<?php

namespace NoahVet\Reef\Iam\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Iam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Iam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class UserInfoNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Iam\Model\UserInfo::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Iam\Model\UserInfo::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Iam\Model\UserInfo();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('sub', $data)) {
            $object->setSub($data['sub']);
            unset($data['sub']);
        }
        if (\array_key_exists('identifier', $data)) {
            $object->setIdentifier($data['identifier']);
            unset($data['identifier']);
        }
        if (\array_key_exists('name', $data) && $data['name'] !== null) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        elseif (\array_key_exists('name', $data) && $data['name'] === null) {
            $object->setName(null);
        }
        if (\array_key_exists('given_name', $data) && $data['given_name'] !== null) {
            $object->setGivenName($data['given_name']);
            unset($data['given_name']);
        }
        elseif (\array_key_exists('given_name', $data) && $data['given_name'] === null) {
            $object->setGivenName(null);
        }
        if (\array_key_exists('family_name', $data) && $data['family_name'] !== null) {
            $object->setFamilyName($data['family_name']);
            unset($data['family_name']);
        }
        elseif (\array_key_exists('family_name', $data) && $data['family_name'] === null) {
            $object->setFamilyName(null);
        }
        if (\array_key_exists('nickname', $data) && $data['nickname'] !== null) {
            $object->setNickname($data['nickname']);
            unset($data['nickname']);
        }
        elseif (\array_key_exists('nickname', $data) && $data['nickname'] === null) {
            $object->setNickname(null);
        }
        if (\array_key_exists('display_name', $data) && $data['display_name'] !== null) {
            $object->setDisplayName($data['display_name']);
            unset($data['display_name']);
        }
        elseif (\array_key_exists('display_name', $data) && $data['display_name'] === null) {
            $object->setDisplayName(null);
        }
        if (\array_key_exists('preferred_username', $data)) {
            $object->setPreferredUsername($data['preferred_username']);
            unset($data['preferred_username']);
        }
        if (\array_key_exists('email', $data) && $data['email'] !== null) {
            $object->setEmail($data['email']);
            unset($data['email']);
        }
        elseif (\array_key_exists('email', $data) && $data['email'] === null) {
            $object->setEmail(null);
        }
        if (\array_key_exists('groups', $data)) {
            $values = [];
            foreach ($data['groups'] as $value) {
                $values[] = $value;
            }
            $object->setGroups($values);
            unset($data['groups']);
        }
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('sub') && null !== $data->getSub()) {
            $dataArray['sub'] = $data->getSub();
        }
        if ($data->isInitialized('identifier') && null !== $data->getIdentifier()) {
            $dataArray['identifier'] = $data->getIdentifier();
        }
        if ($data->isInitialized('name') && null !== $data->getName()) {
            $dataArray['name'] = $data->getName();
        }
        if ($data->isInitialized('givenName') && null !== $data->getGivenName()) {
            $dataArray['given_name'] = $data->getGivenName();
        }
        if ($data->isInitialized('familyName') && null !== $data->getFamilyName()) {
            $dataArray['family_name'] = $data->getFamilyName();
        }
        if ($data->isInitialized('nickname') && null !== $data->getNickname()) {
            $dataArray['nickname'] = $data->getNickname();
        }
        if ($data->isInitialized('displayName') && null !== $data->getDisplayName()) {
            $dataArray['display_name'] = $data->getDisplayName();
        }
        if ($data->isInitialized('preferredUsername') && null !== $data->getPreferredUsername()) {
            $dataArray['preferred_username'] = $data->getPreferredUsername();
        }
        if ($data->isInitialized('email') && null !== $data->getEmail()) {
            $dataArray['email'] = $data->getEmail();
        }
        if ($data->isInitialized('groups') && null !== $data->getGroups()) {
            $values = [];
            foreach ($data->getGroups() as $value) {
                $values[] = $value;
            }
            $dataArray['groups'] = $values;
        }
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Iam\Model\UserInfo::class => false];
    }
}