<?php

namespace NoahVet\Reef\Iam\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Iam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Iam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class PrincipalPutPhoneNumbersItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Iam\Model\PrincipalPutPhoneNumbersItem::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Iam\Model\PrincipalPutPhoneNumbersItem::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Iam\Model\PrincipalPutPhoneNumbersItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('phoneNumber', $data)) {
            $object->setPhoneNumber($data['phoneNumber']);
            unset($data['phoneNumber']);
        }
        if (\array_key_exists('validated', $data) && $data['validated'] !== null) {
            $object->setValidated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['validated']));
            unset($data['validated']);
        }
        elseif (\array_key_exists('validated', $data) && $data['validated'] === null) {
            $object->setValidated(null);
        }
        if (\array_key_exists('validationMethod', $data) && $data['validationMethod'] !== null) {
            $object->setValidationMethod($data['validationMethod']);
            unset($data['validationMethod']);
        }
        elseif (\array_key_exists('validationMethod', $data) && $data['validationMethod'] === null) {
            $object->setValidationMethod(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('phoneNumber') && null !== $data->getPhoneNumber()) {
            $dataArray['phoneNumber'] = $data->getPhoneNumber();
        }
        if ($data->isInitialized('validated') && null !== $data->getValidated()) {
            $dataArray['validated'] = $data->getValidated()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('validationMethod') && null !== $data->getValidationMethod()) {
            $dataArray['validationMethod'] = $data->getValidationMethod();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Iam\Model\PrincipalPutPhoneNumbersItem::class => false];
    }
}