<?php

namespace NoahVet\Reef\Iam\Endpoint;

class GetPolicyResultCollection extends \NoahVet\Reef\Iam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Iam\Runtime\Client\Endpoint
{
    /**
     * List policy results stored in the IAM
     *
     * @param array $queryParameters {
     *     @var int $page The collection page number
     *     @var string $name 
     *     @var array $name[] 
     *     @var string $subject 
     *     @var array $subject[] 
     *     @var string $etag 
     *     @var array $etag[] 
     * }
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     */
    public function __construct(array $queryParameters = [], array $headerParameters = [])
    {
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Iam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return '/api/policy_results';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getQueryOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'name', 'subject', 'etag']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults(['page' => 1]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('name', ['string']);
        $optionsResolver->addAllowedTypes('name', ['array']);
        $optionsResolver->addAllowedTypes('subject', ['string']);
        $optionsResolver->addAllowedTypes('subject', ['array']);
        $optionsResolver->addAllowedTypes('etag', ['string']);
        $optionsResolver->addAllowedTypes('etag', ['array']);
        return $optionsResolver;
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['X-Reef-Client-ID', 'X-Reef-Client-HMAC']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('X-Reef-Client-ID', ['string']);
        $optionsResolver->addAllowedTypes('X-Reef-Client-HMAC', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PolicyResult[]
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Iam\\Model\\PolicyResult[]', 'json');
        }
        throw new \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}