<?php

namespace NoahVet\Reef\Iam\Normalizer;

use NoahVet\Reef\Iam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Iam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class JaneObjectNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    protected $normalizers = [
        
        \NoahVet\Reef\Iam\Model\ResourceGroupResourceGroupGet::class => \NoahVet\Reef\Iam\Normalizer\ResourceGroupResourceGroupGetNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\ResourceGroupGet::class => \NoahVet\Reef\Iam\Normalizer\ResourceGroupGetNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\ResourceGroupPost::class => \NoahVet\Reef\Iam\Normalizer\ResourceGroupPostNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\ResourceGroupPut::class => \NoahVet\Reef\Iam\Normalizer\ResourceGroupPutNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\ClientResponse::class => \NoahVet\Reef\Iam\Normalizer\ClientResponseNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\ServicePermission::class => \NoahVet\Reef\Iam\Normalizer\ServicePermissionNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\ServiceResource::class => \NoahVet\Reef\Iam\Normalizer\ServiceResourceNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\ServiceExternalResource::class => \NoahVet\Reef\Iam\Normalizer\ServiceExternalResourceNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\ServiceDefinition::class => \NoahVet\Reef\Iam\Normalizer\ServiceDefinitionNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\PolicyResult::class => \NoahVet\Reef\Iam\Normalizer\PolicyResultNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\GrantedPermissionShort::class => \NoahVet\Reef\Iam\Normalizer\GrantedPermissionShortNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\PolicyResultPost::class => \NoahVet\Reef\Iam\Normalizer\PolicyResultPostNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\PostalAddress::class => \NoahVet\Reef\Iam\Normalizer\PostalAddressNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\PrincipalItem::class => \NoahVet\Reef\Iam\Normalizer\PrincipalItemNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\PrincipalItemPhoneNumbersItem::class => \NoahVet\Reef\Iam\Normalizer\PrincipalItemPhoneNumbersItemNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\PrincipalShort::class => \NoahVet\Reef\Iam\Normalizer\PrincipalShortNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\PrincipalPut::class => \NoahVet\Reef\Iam\Normalizer\PrincipalPutNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\PrincipalPutPhoneNumbersItem::class => \NoahVet\Reef\Iam\Normalizer\PrincipalPutPhoneNumbersItemNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\ResourceTypeItem::class => \NoahVet\Reef\Iam\Normalizer\ResourceTypeItemNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\PermissionGrant::class => \NoahVet\Reef\Iam\Normalizer\PermissionGrantNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\PermissionGrantList::class => \NoahVet\Reef\Iam\Normalizer\PermissionGrantListNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\Resource::class => \NoahVet\Reef\Iam\Normalizer\ResourceNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\TokenInfo::class => \NoahVet\Reef\Iam\Normalizer\TokenInfoNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\UserInfo::class => \NoahVet\Reef\Iam\Normalizer\UserInfoNormalizer::class,
        
        \NoahVet\Reef\Iam\Model\OauthV2RevokePostResponse400::class => \NoahVet\Reef\Iam\Normalizer\OauthV2RevokePostResponse400Normalizer::class,
        
        \NoahVet\Reef\Iam\Model\OauthV2TokenInfoTokenGetResponse401::class => \NoahVet\Reef\Iam\Normalizer\OauthV2TokenInfoTokenGetResponse401Normalizer::class,
        
        \NoahVet\Reef\Iam\Model\UserinfoGetResponse401::class => \NoahVet\Reef\Iam\Normalizer\UserinfoGetResponse401Normalizer::class,
        
        \Jane\Component\JsonSchemaRuntime\Reference::class => \NoahVet\Reef\Iam\Runtime\Normalizer\ReferenceNormalizer::class,
    ], $normalizersCache = [];
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return array_key_exists($type, $this->normalizers);
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && array_key_exists(get_class($data), $this->normalizers);
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $normalizerClass = $this->normalizers[get_class($data)];
        $normalizer = $this->getNormalizer($normalizerClass);
        return $normalizer->normalize($data, $format, $context);
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        $denormalizerClass = $this->normalizers[$type];
        $denormalizer = $this->getNormalizer($denormalizerClass);
        return $denormalizer->denormalize($data, $type, $format, $context);
    }
    private function getNormalizer(string $normalizerClass)
    {
        return $this->normalizersCache[$normalizerClass] ?? $this->initNormalizer($normalizerClass);
    }
    private function initNormalizer(string $normalizerClass)
    {
        $normalizer = new $normalizerClass();
        $normalizer->setNormalizer($this->normalizer);
        $normalizer->setDenormalizer($this->denormalizer);
        $this->normalizersCache[$normalizerClass] = $normalizer;
        return $normalizer;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [
            
            \NoahVet\Reef\Iam\Model\ResourceGroupResourceGroupGet::class => false,
            \NoahVet\Reef\Iam\Model\ResourceGroupGet::class => false,
            \NoahVet\Reef\Iam\Model\ResourceGroupPost::class => false,
            \NoahVet\Reef\Iam\Model\ResourceGroupPut::class => false,
            \NoahVet\Reef\Iam\Model\ClientResponse::class => false,
            \NoahVet\Reef\Iam\Model\ServicePermission::class => false,
            \NoahVet\Reef\Iam\Model\ServiceResource::class => false,
            \NoahVet\Reef\Iam\Model\ServiceExternalResource::class => false,
            \NoahVet\Reef\Iam\Model\ServiceDefinition::class => false,
            \NoahVet\Reef\Iam\Model\PolicyResult::class => false,
            \NoahVet\Reef\Iam\Model\GrantedPermissionShort::class => false,
            \NoahVet\Reef\Iam\Model\PolicyResultPost::class => false,
            \NoahVet\Reef\Iam\Model\PostalAddress::class => false,
            \NoahVet\Reef\Iam\Model\PrincipalItem::class => false,
            \NoahVet\Reef\Iam\Model\PrincipalItemPhoneNumbersItem::class => false,
            \NoahVet\Reef\Iam\Model\PrincipalShort::class => false,
            \NoahVet\Reef\Iam\Model\PrincipalPut::class => false,
            \NoahVet\Reef\Iam\Model\PrincipalPutPhoneNumbersItem::class => false,
            \NoahVet\Reef\Iam\Model\ResourceTypeItem::class => false,
            \NoahVet\Reef\Iam\Model\PermissionGrant::class => false,
            \NoahVet\Reef\Iam\Model\PermissionGrantList::class => false,
            \NoahVet\Reef\Iam\Model\Resource::class => false,
            \NoahVet\Reef\Iam\Model\TokenInfo::class => false,
            \NoahVet\Reef\Iam\Model\UserInfo::class => false,
            \NoahVet\Reef\Iam\Model\OauthV2RevokePostResponse400::class => false,
            \NoahVet\Reef\Iam\Model\OauthV2TokenInfoTokenGetResponse401::class => false,
            \NoahVet\Reef\Iam\Model\UserinfoGetResponse401::class => false,
            \Jane\Component\JsonSchemaRuntime\Reference::class => false,
        ];
    }
}