<?php

namespace NoahVet\Reef\Iam\Endpoint;

class PostPolicyResultCollection extends \NoahVet\Reef\Iam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Iam\Runtime\Client\Endpoint
{
    /**
     * Store a policy result in the IAM
     *
     * @param \NoahVet\Reef\Iam\Model\PolicyResultPost $requestBody 
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     */
    public function __construct(\NoahVet\Reef\Iam\Model\PolicyResultPost $requestBody, array $headerParameters = [])
    {
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Iam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'POST';
    }
    public function getUri() : string
    {
        return '/api/policy_results';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Iam\Model\PolicyResultPost) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['X-Reef-Client-ID', 'X-Reef-Client-HMAC']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('X-Reef-Client-ID', ['string']);
        $optionsResolver->addAllowedTypes('X-Reef-Client-HMAC', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Iam\Exception\PostPolicyResultCollectionBadRequestException
     * @throws \NoahVet\Reef\Iam\Exception\PostPolicyResultCollectionUnprocessableEntityException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PolicyResult
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (201 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Iam\\Model\\PolicyResult', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Iam\Exception\PostPolicyResultCollectionBadRequestException($response);
        }
        if (422 === $status) {
            throw new \NoahVet\Reef\Iam\Exception\PostPolicyResultCollectionUnprocessableEntityException($response);
        }
        throw new \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}