<?php

namespace NoahVet\Reef\Iam\Endpoint;

class PutPrincipalItem extends \NoahVet\Reef\Iam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Iam\Runtime\Client\Endpoint
{
    protected $id;
    /**
     * Update a principal
     *
     * @param string $id Principal identifier
     * @param \NoahVet\Reef\Iam\Model\PrincipalPut $requestBody 
     */
    public function __construct(string $id, \NoahVet\Reef\Iam\Model\PrincipalPut $requestBody)
    {
        $this->id = $id;
        $this->body = $requestBody;
    }
    use \NoahVet\Reef\Iam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'PUT';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/api/principals/{id}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Iam\Model\PrincipalPut) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Iam\Exception\PutPrincipalItemBadRequestException
     * @throws \NoahVet\Reef\Iam\Exception\PutPrincipalItemUnprocessableEntityException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PrincipalItem
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Iam\\Model\\PrincipalItem', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Iam\Exception\PutPrincipalItemBadRequestException($response);
        }
        if (422 === $status) {
            throw new \NoahVet\Reef\Iam\Exception\PutPrincipalItemUnprocessableEntityException($response);
        }
        throw new \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}