<?php

namespace NoahVet\Reef\Iam\Endpoint;

class OauthTokenInfo extends \NoahVet\Reef\Iam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Iam\Runtime\Client\Endpoint
{
    protected $token;
    /**
     * Retrieve token info from token
     *
     * @param string $token The token
     */
    public function __construct(string $token)
    {
        $this->token = $token;
    }
    use \NoahVet\Reef\Iam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return str_replace(['{token}'], [$this->token], '/oauth/v2/token_info/{token}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Iam\Exception\OauthTokenInfoUnauthorizedException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\TokenInfo
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Iam\\Model\\TokenInfo', 'json');
        }
        if (is_null($contentType) === false && (401 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Iam\Exception\OauthTokenInfoUnauthorizedException($serializer->deserialize($body, 'NoahVet\\Reef\\Iam\\Model\\OauthV2TokenInfoTokenGetResponse401', 'json'), $response);
        }
        throw new \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}