<?php

namespace NoahVet\Reef\Iam\Model;

class PrincipalItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Identifier of the principal (UUID)
     *
     * @var string
     */
    protected $id;
    /**
     * Email if the principal is a person
     *
     * @var string|null
     */
    protected $email;
    /**
     * Last name of the person
     *
     * @var string|null
     */
    protected $lastname;
    /**
     * First name of the person
     *
     * @var string|null
     */
    protected $firstname;
    /**
     * Status of the principal
     *
     * @var string
     */
    protected $status;
    /**
     * Locale to use. If not provided, detected during account validation.
     *
     * @var string|null
     */
    protected $locale;
    /**
     * Timezone to use. If not provided, detected during account validation.
     *
     * @var string|null
     */
    protected $timezone;
    /**
     * Birth date if the principal a person
     *
     * @var \DateTime|null
     */
    protected $birthDate;
    /**
     * Postcode of birth, if principal is a person
     *
     * @var string|null
     */
    protected $birthPostCode;
    /**
     * City of birth, if principal is a person
     *
     * @var string|null
     */
    protected $birthCity;
    /**
     * Country of birth, if principal is a person. ISO 3 letters.
     *
     * @var string|null
     */
    protected $birthCountry;
    /**
     * 
     *
     * @var PostalAddress
     */
    protected $mainAddress;
    /**
     * If privacy policy was accepted, the date of acceptance
     *
     * @var \DateTime|null
     */
    protected $privacyPolicyAccepted;
    /**
     * 
     *
     * @var string|null
     */
    protected $mainPhoneNumber;
    /**
     * 
     *
     * @var list<PrincipalItemPhoneNumbersItem>
     */
    protected $phoneNumbers;
    /**
     * Date of creation of the principal
     *
     * @var \DateTime
     */
    protected $created;
    /**
     * Date of last update of the principal
     *
     * @var \DateTime
     */
    protected $updated;
    /**
     * Identifier of the principal (UUID)
     *
     * @return string
     */
    public function getId() : string
    {
        return $this->id;
    }
    /**
     * Identifier of the principal (UUID)
     *
     * @param string $id
     *
     * @return self
     */
    public function setId(string $id) : self
    {
        $this->initialized['id'] = true;
        $this->id = $id;
        return $this;
    }
    /**
     * Email if the principal is a person
     *
     * @return string|null
     */
    public function getEmail() : ?string
    {
        return $this->email;
    }
    /**
     * Email if the principal is a person
     *
     * @param string|null $email
     *
     * @return self
     */
    public function setEmail(?string $email) : self
    {
        $this->initialized['email'] = true;
        $this->email = $email;
        return $this;
    }
    /**
     * Last name of the person
     *
     * @return string|null
     */
    public function getLastname() : ?string
    {
        return $this->lastname;
    }
    /**
     * Last name of the person
     *
     * @param string|null $lastname
     *
     * @return self
     */
    public function setLastname(?string $lastname) : self
    {
        $this->initialized['lastname'] = true;
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * First name of the person
     *
     * @return string|null
     */
    public function getFirstname() : ?string
    {
        return $this->firstname;
    }
    /**
     * First name of the person
     *
     * @param string|null $firstname
     *
     * @return self
     */
    public function setFirstname(?string $firstname) : self
    {
        $this->initialized['firstname'] = true;
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Status of the principal
     *
     * @return string
     */
    public function getStatus() : string
    {
        return $this->status;
    }
    /**
     * Status of the principal
     *
     * @param string $status
     *
     * @return self
     */
    public function setStatus(string $status) : self
    {
        $this->initialized['status'] = true;
        $this->status = $status;
        return $this;
    }
    /**
     * Locale to use. If not provided, detected during account validation.
     *
     * @return string|null
     */
    public function getLocale() : ?string
    {
        return $this->locale;
    }
    /**
     * Locale to use. If not provided, detected during account validation.
     *
     * @param string|null $locale
     *
     * @return self
     */
    public function setLocale(?string $locale) : self
    {
        $this->initialized['locale'] = true;
        $this->locale = $locale;
        return $this;
    }
    /**
     * Timezone to use. If not provided, detected during account validation.
     *
     * @return string|null
     */
    public function getTimezone() : ?string
    {
        return $this->timezone;
    }
    /**
     * Timezone to use. If not provided, detected during account validation.
     *
     * @param string|null $timezone
     *
     * @return self
     */
    public function setTimezone(?string $timezone) : self
    {
        $this->initialized['timezone'] = true;
        $this->timezone = $timezone;
        return $this;
    }
    /**
     * Birth date if the principal a person
     *
     * @return \DateTime|null
     */
    public function getBirthDate() : ?\DateTime
    {
        return $this->birthDate;
    }
    /**
     * Birth date if the principal a person
     *
     * @param \DateTime|null $birthDate
     *
     * @return self
     */
    public function setBirthDate(?\DateTime $birthDate) : self
    {
        $this->initialized['birthDate'] = true;
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Postcode of birth, if principal is a person
     *
     * @return string|null
     */
    public function getBirthPostCode() : ?string
    {
        return $this->birthPostCode;
    }
    /**
     * Postcode of birth, if principal is a person
     *
     * @param string|null $birthPostCode
     *
     * @return self
     */
    public function setBirthPostCode(?string $birthPostCode) : self
    {
        $this->initialized['birthPostCode'] = true;
        $this->birthPostCode = $birthPostCode;
        return $this;
    }
    /**
     * City of birth, if principal is a person
     *
     * @return string|null
     */
    public function getBirthCity() : ?string
    {
        return $this->birthCity;
    }
    /**
     * City of birth, if principal is a person
     *
     * @param string|null $birthCity
     *
     * @return self
     */
    public function setBirthCity(?string $birthCity) : self
    {
        $this->initialized['birthCity'] = true;
        $this->birthCity = $birthCity;
        return $this;
    }
    /**
     * Country of birth, if principal is a person. ISO 3 letters.
     *
     * @return string|null
     */
    public function getBirthCountry() : ?string
    {
        return $this->birthCountry;
    }
    /**
     * Country of birth, if principal is a person. ISO 3 letters.
     *
     * @param string|null $birthCountry
     *
     * @return self
     */
    public function setBirthCountry(?string $birthCountry) : self
    {
        $this->initialized['birthCountry'] = true;
        $this->birthCountry = $birthCountry;
        return $this;
    }
    /**
     * 
     *
     * @return PostalAddress
     */
    public function getMainAddress() : PostalAddress
    {
        return $this->mainAddress;
    }
    /**
     * 
     *
     * @param PostalAddress $mainAddress
     *
     * @return self
     */
    public function setMainAddress(PostalAddress $mainAddress) : self
    {
        $this->initialized['mainAddress'] = true;
        $this->mainAddress = $mainAddress;
        return $this;
    }
    /**
     * If privacy policy was accepted, the date of acceptance
     *
     * @return \DateTime|null
     */
    public function getPrivacyPolicyAccepted() : ?\DateTime
    {
        return $this->privacyPolicyAccepted;
    }
    /**
     * If privacy policy was accepted, the date of acceptance
     *
     * @param \DateTime|null $privacyPolicyAccepted
     *
     * @return self
     */
    public function setPrivacyPolicyAccepted(?\DateTime $privacyPolicyAccepted) : self
    {
        $this->initialized['privacyPolicyAccepted'] = true;
        $this->privacyPolicyAccepted = $privacyPolicyAccepted;
        return $this;
    }
    /**
     * 
     *
     * @return string|null
     */
    public function getMainPhoneNumber() : ?string
    {
        return $this->mainPhoneNumber;
    }
    /**
     * 
     *
     * @param string|null $mainPhoneNumber
     *
     * @return self
     */
    public function setMainPhoneNumber(?string $mainPhoneNumber) : self
    {
        $this->initialized['mainPhoneNumber'] = true;
        $this->mainPhoneNumber = $mainPhoneNumber;
        return $this;
    }
    /**
     * 
     *
     * @return list<PrincipalItemPhoneNumbersItem>
     */
    public function getPhoneNumbers() : array
    {
        return $this->phoneNumbers;
    }
    /**
     * 
     *
     * @param list<PrincipalItemPhoneNumbersItem> $phoneNumbers
     *
     * @return self
     */
    public function setPhoneNumbers(array $phoneNumbers) : self
    {
        $this->initialized['phoneNumbers'] = true;
        $this->phoneNumbers = $phoneNumbers;
        return $this;
    }
    /**
     * Date of creation of the principal
     *
     * @return \DateTime
     */
    public function getCreated() : \DateTime
    {
        return $this->created;
    }
    /**
     * Date of creation of the principal
     *
     * @param \DateTime $created
     *
     * @return self
     */
    public function setCreated(\DateTime $created) : self
    {
        $this->initialized['created'] = true;
        $this->created = $created;
        return $this;
    }
    /**
     * Date of last update of the principal
     *
     * @return \DateTime
     */
    public function getUpdated() : \DateTime
    {
        return $this->updated;
    }
    /**
     * Date of last update of the principal
     *
     * @param \DateTime $updated
     *
     * @return self
     */
    public function setUpdated(\DateTime $updated) : self
    {
        $this->initialized['updated'] = true;
        $this->updated = $updated;
        return $this;
    }
}