<?php

namespace NoahVet\Reef\Iam\Model;

class ResourceTypeItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * 
     *
     * @var string
     */
    protected $friendlyName;
    /**
     * 
     *
     * @var string
     */
    protected $slug;
    /**
     * 
     *
     * @var string
     */
    protected $groupSlug;
    /**
     * 
     *
     * @var string|null
     */
    protected $description;
    /**
     * 
     *
     * @var bool
     */
    protected $prefixMandatory = true;
    /**
     * 
     *
     * @return string
     */
    public function getFriendlyName() : string
    {
        return $this->friendlyName;
    }
    /**
     * 
     *
     * @param string $friendlyName
     *
     * @return self
     */
    public function setFriendlyName(string $friendlyName) : self
    {
        $this->initialized['friendlyName'] = true;
        $this->friendlyName = $friendlyName;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getSlug() : string
    {
        return $this->slug;
    }
    /**
     * 
     *
     * @param string $slug
     *
     * @return self
     */
    public function setSlug(string $slug) : self
    {
        $this->initialized['slug'] = true;
        $this->slug = $slug;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getGroupSlug() : string
    {
        return $this->groupSlug;
    }
    /**
     * 
     *
     * @param string $groupSlug
     *
     * @return self
     */
    public function setGroupSlug(string $groupSlug) : self
    {
        $this->initialized['groupSlug'] = true;
        $this->groupSlug = $groupSlug;
        return $this;
    }
    /**
     * 
     *
     * @return string|null
     */
    public function getDescription() : ?string
    {
        return $this->description;
    }
    /**
     * 
     *
     * @param string|null $description
     *
     * @return self
     */
    public function setDescription(?string $description) : self
    {
        $this->initialized['description'] = true;
        $this->description = $description;
        return $this;
    }
    /**
     * 
     *
     * @return bool
     */
    public function getPrefixMandatory() : bool
    {
        return $this->prefixMandatory;
    }
    /**
     * 
     *
     * @param bool $prefixMandatory
     *
     * @return self
     */
    public function setPrefixMandatory(bool $prefixMandatory) : self
    {
        $this->initialized['prefixMandatory'] = true;
        $this->prefixMandatory = $prefixMandatory;
        return $this;
    }
}