<?php

namespace NoahVet\Reef\Iam\Endpoint;

class PutResourceItem extends \NoahVet\Reef\Iam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Iam\Runtime\Client\Endpoint
{
    protected $slug;
    /**
     * Replaces the Resource resource.
     *
     * @param string $slug Resource identifier
     * @param \NoahVet\Reef\Iam\Model\Resource $requestBody 
     */
    public function __construct(string $slug, \NoahVet\Reef\Iam\Model\Resource $requestBody)
    {
        $this->slug = $slug;
        $this->body = $requestBody;
    }
    use \NoahVet\Reef\Iam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'PUT';
    }
    public function getUri() : string
    {
        return str_replace(['{slug}'], [$this->slug], '/api/resources/{slug}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Iam\Model\Resource) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Iam\Exception\PutResourceItemBadRequestException
     * @throws \NoahVet\Reef\Iam\Exception\PutResourceItemNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\PutResourceItemUnprocessableEntityException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\Resource
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Iam\\Model\\Resource', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Iam\Exception\PutResourceItemBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Iam\Exception\PutResourceItemNotFoundException($response);
        }
        if (422 === $status) {
            throw new \NoahVet\Reef\Iam\Exception\PutResourceItemUnprocessableEntityException($response);
        }
        throw new \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}