<?php

namespace NoahVet\Reef\Iam\Model;

class ServiceDefinition extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * 
     *
     * @var string
     */
    protected $id;
    /**
     * 
     *
     * @var string
     */
    protected $name;
    /**
     * 
     *
     * @var array<string, ServiceResource>
     */
    protected $resources;
    /**
     * 
     *
     * @var array<string, ServiceExternalResource>
     */
    protected $externalResources;
    /**
     * 
     *
     * @return string
     */
    public function getId() : string
    {
        return $this->id;
    }
    /**
     * 
     *
     * @param string $id
     *
     * @return self
     */
    public function setId(string $id) : self
    {
        $this->initialized['id'] = true;
        $this->id = $id;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getName() : string
    {
        return $this->name;
    }
    /**
     * 
     *
     * @param string $name
     *
     * @return self
     */
    public function setName(string $name) : self
    {
        $this->initialized['name'] = true;
        $this->name = $name;
        return $this;
    }
    /**
     * 
     *
     * @return array<string, ServiceResource>
     */
    public function getResources() : iterable
    {
        return $this->resources;
    }
    /**
     * 
     *
     * @param array<string, ServiceResource> $resources
     *
     * @return self
     */
    public function setResources(iterable $resources) : self
    {
        $this->initialized['resources'] = true;
        $this->resources = $resources;
        return $this;
    }
    /**
     * 
     *
     * @return array<string, ServiceExternalResource>
     */
    public function getExternalResources() : iterable
    {
        return $this->externalResources;
    }
    /**
     * 
     *
     * @param array<string, ServiceExternalResource> $externalResources
     *
     * @return self
     */
    public function setExternalResources(iterable $externalResources) : self
    {
        $this->initialized['externalResources'] = true;
        $this->externalResources = $externalResources;
        return $this;
    }
}