<?php

namespace NoahVet\Reef\Iam;

class Client extends \NoahVet\Reef\Iam\Runtime\Client\Client
{
    /**
     * Retrieve generic information about an OAuth client
     *
     * @param string $slug Resource identifier
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\GetClientItemNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\ClientResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getClientItem(string $slug, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetClientItem($slug), $fetch);
    }
    /**
     * Update client resources types and allowed permissions
     *
     * @param string $slug Resource identifier
     * @param \NoahVet\Reef\Iam\Model\ServiceDefinition $requestBody 
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\PutClientItemDefinitionBadRequestException
     * @throws \NoahVet\Reef\Iam\Exception\PutClientItemDefinitionNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\PutClientItemDefinitionUnprocessableEntityException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\ServiceDefinition|\Psr\Http\Message\ResponseInterface
     */
    public function putClientItemDefinition(string $slug, \NoahVet\Reef\Iam\Model\ServiceDefinition $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\PutClientItemDefinition($slug, $requestBody, $headerParameters), $fetch);
    }
    /**
     * List policy results stored in the IAM
     *
     * @param array $queryParameters {
     *     @var int $page The collection page number
     *     @var string $name 
     *     @var array $name[] 
     *     @var string $subject 
     *     @var array $subject[] 
     *     @var string $etag 
     *     @var array $etag[] 
     * }
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PolicyResult[]|\Psr\Http\Message\ResponseInterface
     */
    public function getPolicyResultCollection(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetPolicyResultCollection($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Store a policy result in the IAM
     *
     * @param \NoahVet\Reef\Iam\Model\PolicyResultPost $requestBody 
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\PostPolicyResultCollectionBadRequestException
     * @throws \NoahVet\Reef\Iam\Exception\PostPolicyResultCollectionUnprocessableEntityException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PolicyResult|\Psr\Http\Message\ResponseInterface
     */
    public function postPolicyResultCollection(\NoahVet\Reef\Iam\Model\PolicyResultPost $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\PostPolicyResultCollection($requestBody, $headerParameters), $fetch);
    }
    /**
     * Get a specific policy result
     *
     * @param string $id Resource identifier
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\GetPolicyResultItemNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PolicyResult|\Psr\Http\Message\ResponseInterface
     */
    public function getPolicyResultItem(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetPolicyResultItem($id, $headerParameters), $fetch);
    }
    /**
     * List principals
     *
     * @param array $queryParameters {
     *     @var int $page The collection page number
     *     @var string $email 
     *     @var string $id 
     *     @var string $id[] 
     *     @var string $order[id] 
     *     @var string $order[email] 
     *     @var string $order[created] 
     *     @var string $order[updated] 
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PrincipalItem[]|\Psr\Http\Message\ResponseInterface
     */
    public function getPrincipalCollection(array $queryParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetPrincipalCollection($queryParameters), $fetch);
    }
    /**
     * Invite a person to join the reef by validating a pre-created account
     *
     * @param \NoahVet\Reef\Iam\Model\PrincipalShort $requestBody 
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\PostPrincipalCollectionBadRequestException
     * @throws \NoahVet\Reef\Iam\Exception\PostPrincipalCollectionUnprocessableEntityException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PrincipalItem|\Psr\Http\Message\ResponseInterface
     */
    public function postPrincipalCollection(\NoahVet\Reef\Iam\Model\PrincipalShort $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\PostPrincipalCollection($requestBody, $headerParameters), $fetch);
    }
    /**
     * Retrieves a Principal
     *
     * @param string $id Principal identifier
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\GetPrincipalItemNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PrincipalItem|\Psr\Http\Message\ResponseInterface
     */
    public function getPrincipalItem(string $id, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetPrincipalItem($id), $fetch);
    }
    /**
     * Update a principal
     *
     * @param \NoahVet\Reef\Iam\Model\PrincipalPut $requestBody 
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\PutPrincipalItemBadRequestException
     * @throws \NoahVet\Reef\Iam\Exception\PutPrincipalItemUnprocessableEntityException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PrincipalItem|\Psr\Http\Message\ResponseInterface
     */
    public function putPrincipalItem(\NoahVet\Reef\Iam\Model\PrincipalPut $requestBody, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\PutPrincipalItem($requestBody), $fetch);
    }
    /**
     * Retrieves a ResourceType
     *
     * @param string $slug Resource identifier
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\GetResourceTypeItemNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\ResourceTypeItem|\Psr\Http\Message\ResponseInterface
     */
    public function getResourceTypeItem(string $slug, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetResourceTypeItem($slug), $fetch);
    }
    /**
     * Retrieve effective permissions on alle resources a the specified resource type
     *
     * @param string $slug Resource identifier
     * @param array $queryParameters {
     *     @var string $principal Principal ID (if different from the one doing the query)
     * }
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\GetResourceTypeItemDetailedPermissionsNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PermissionGrantList|\Psr\Http\Message\ResponseInterface
     */
    public function getResourceTypeItemDetailedPermissions(string $slug, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetResourceTypeItemDetailedPermissions($slug, $queryParameters, $headerParameters), $fetch);
    }
    /**
     * Retrieves a ResourceType resource.
     *
     * @param string $slug Resource identifier
     * @param array $queryParameters {
     *     @var string $principal Principal ID (if different from the one doing the query)
     * }
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\GetResourceTypeItemPermissionsNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PermissionGrantList|\Psr\Http\Message\ResponseInterface
     */
    public function getResourceTypeItemPermissions(string $slug, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetResourceTypeItemPermissions($slug, $queryParameters, $headerParameters), $fetch);
    }
    /**
     * Retrieves the collection of Resource resources.
     *
     * @param string $slug Resource identifier
     * @param array $queryParameters {
     *     @var int $page The collection page number
     *     @var int $itemsPerPage The number of items per page
     *     @var array $slug[] 
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\Resource[]|\Psr\Http\Message\ResponseInterface
     */
    public function getResourceCollection(string $slug, array $queryParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetResourceCollection($slug, $queryParameters), $fetch);
    }
    /**
     * Creates a Resource resource.
     *
     * @param \NoahVet\Reef\Iam\Model\Resource $requestBody 
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\PostResourceCollectionBadRequestException
     * @throws \NoahVet\Reef\Iam\Exception\PostResourceCollectionUnprocessableEntityException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\Resource|\Psr\Http\Message\ResponseInterface
     */
    public function postResourceCollection(\NoahVet\Reef\Iam\Model\Resource $requestBody, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\PostResourceCollection($requestBody), $fetch);
    }
    /**
     * Retrieves a Resource resource.
     *
     * @param string $slug Resource identifier
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\GetResourceItemDetailedPermissionsNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PermissionGrantList|\Psr\Http\Message\ResponseInterface
     */
    public function getResourceItemDetailedPermissions(string $slug, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetResourceItemDetailedPermissions($slug, $headerParameters), $fetch);
    }
    /**
     * Retrieves a Resource resource.
     *
     * @param string $slug Resource identifier
     * @param array $queryParameters {
     *     @var string $principal Principal ID (if different from the one doing the query)
     * }
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\GetResourceItemPermissionsNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PermissionGrantList|\Psr\Http\Message\ResponseInterface
     */
    public function getResourceItemPermissions(string $slug, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetResourceItemPermissions($slug, $queryParameters, $headerParameters), $fetch);
    }
    /**
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\OauthRevokeTokenBadRequestException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function oauthRevokeToken(string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\OauthRevokeToken(), $fetch);
    }
    /**
     * Retrieve token info from token
     *
     * @param string $token The token
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\OauthTokenInfoUnauthorizedException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\TokenInfo|\Psr\Http\Message\ResponseInterface
     */
    public function oauthTokenInfo(string $token, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\OauthTokenInfo($token), $fetch);
    }
    /**
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\OauthUserinfoUnauthorizedException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\UserInfo|\Psr\Http\Message\ResponseInterface
     */
    public function oauthUserinfo(string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\OauthUserinfo(), $fetch);
    }
    /**
     * Create a resource group
     *
     * @param \NoahVet\Reef\Iam\Model\ResourceGroupPost $requestBody 
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\ResourceGroupGet|null|\Psr\Http\Message\ResponseInterface
     */
    public function getResourceGroupCollection(\NoahVet\Reef\Iam\Model\ResourceGroupPost $requestBody, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetResourceGroupCollection($requestBody), $fetch);
    }
    /**
     * Read a resource group
     *
     * @param string $slug Resource group slug
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\GetResourceGroupItemNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\ResourceGroupGet|\Psr\Http\Message\ResponseInterface
     */
    public function getResourceGroupItem(string $slug, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetResourceGroupItem($slug), $fetch);
    }
    /**
     * Update a resource group
     *
     * @param string $slug Resource group slug
     * @param \NoahVet\Reef\Iam\Model\ResourceGroupPut $requestBody 
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\PutResourceGroupItemNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\ResourceGroupGet|\Psr\Http\Message\ResponseInterface
     */
    public function putResourceGroupItem(string $slug, \NoahVet\Reef\Iam\Model\ResourceGroupPut $requestBody, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\PutResourceGroupItem($slug, $requestBody), $fetch);
    }
    /**
     * Retrieves a ResourceGroup resource.
     *
     * @param string $slug Resource identifier
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\GetResourceGroupItemPermissionsNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\ResourceGroupResourceGroupGet|\Psr\Http\Message\ResponseInterface
     */
    public function getResourceGroupItemPermissions(string $slug, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetResourceGroupItemPermissions($slug), $fetch);
    }
    /**
     * Retrieve effective permissions on a collection of resources
     *
     * @param string $slug Resource identifier
     * @param array $queryParameters {
     *     @var array $slug[] List of resources you want permissions for
     *     @var string $principal Principal ID (if different from the one doing the query)
     *     @var int $page The collection page number
     *     @var int $itemsPerPage The number of items per page
     * }
     * @param array $headerParameters {
     *     @var string $X-Reef-Client-ID Public OAuth Client ID
     *     @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\PermissionGrantList|\Psr\Http\Message\ResponseInterface
     */
    public function getResourceCollectionPermissions(string $slug, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetResourceCollectionPermissions($slug, $queryParameters, $headerParameters), $fetch);
    }
    /**
     * Retrieves a Resource resource.
     *
     * @param string $slug Resource identifier
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\GetResourceItemNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\Resource|\Psr\Http\Message\ResponseInterface
     */
    public function getResourceItem(string $slug, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\GetResourceItem($slug), $fetch);
    }
    /**
     * Replaces the Resource resource.
     *
     * @param string $slug Resource identifier
     * @param \NoahVet\Reef\Iam\Model\Resource $requestBody 
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Iam\Exception\PutResourceItemBadRequestException
     * @throws \NoahVet\Reef\Iam\Exception\PutResourceItemNotFoundException
     * @throws \NoahVet\Reef\Iam\Exception\PutResourceItemUnprocessableEntityException
     * @throws \NoahVet\Reef\Iam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Iam\Model\Resource|\Psr\Http\Message\ResponseInterface
     */
    public function putResourceItem(string $slug, \NoahVet\Reef\Iam\Model\Resource $requestBody, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Iam\Endpoint\PutResourceItem($slug, $requestBody), $fetch);
    }
    public static function create($httpClient = null, array $additionalPlugins = [], array $additionalNormalizers = [])
    {
        if (null === $httpClient) {
            $httpClient = \Http\Discovery\Psr18ClientDiscovery::find();
            $plugins = [];
            if (count($additionalPlugins) > 0) {
                $plugins = array_merge($plugins, $additionalPlugins);
            }
            $httpClient = new \Http\Client\Common\PluginClient($httpClient, $plugins);
        }
        $requestFactory = \Http\Discovery\Psr17FactoryDiscovery::findRequestFactory();
        $streamFactory = \Http\Discovery\Psr17FactoryDiscovery::findStreamFactory();
        $normalizers = [new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \NoahVet\Reef\Iam\Normalizer\JaneObjectNormalizer()];
        if (count($additionalNormalizers) > 0) {
            $normalizers = array_merge($normalizers, $additionalNormalizers);
        }
        $serializer = new \Symfony\Component\Serializer\Serializer($normalizers, [new \Symfony\Component\Serializer\Encoder\JsonEncoder(new \Symfony\Component\Serializer\Encoder\JsonEncode(), new \Symfony\Component\Serializer\Encoder\JsonDecode(['json_decode_associative' => true]))]);
        return new static($httpClient, $requestFactory, $serializer, $streamFactory);
    }
}