<?php

namespace NoahVet\Reef\Cam\Endpoint;

class DeleteOneContact extends \NoahVet\Reef\Cam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Cam\Runtime\Client\Endpoint
{
    protected $id;
    /**
     * Delete a Contact.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(string $id, array $headerParameters = [])
    {
        $this->id = $id;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Cam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'DELETE';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/v1/contacts/{id}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOneContactBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOneContactNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOneContactInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (204 === $status) {
            return null;
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Cam\Exception\DeleteOneContactBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Cam\Exception\DeleteOneContactNotFoundException($response);
        }
        if (500 === $status) {
            throw new \NoahVet\Reef\Cam\Exception\DeleteOneContactInternalServerErrorException($response);
        }
        throw new \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}