<?php

namespace NoahVet\Reef\Cam\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Cam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Cam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class NullableCompanyDetailRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Cam\Model\NullableCompanyDetailRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Cam\Model\NullableCompanyDetailRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Cam\Model\NullableCompanyDetailRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('legalCode', $data) && $data['legalCode'] !== null) {
            $object->setLegalCode($data['legalCode']);
            unset($data['legalCode']);
        }
        elseif (\array_key_exists('legalCode', $data) && $data['legalCode'] === null) {
            $object->setLegalCode(null);
        }
        if (\array_key_exists('name', $data) && $data['name'] !== null) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        elseif (\array_key_exists('name', $data) && $data['name'] === null) {
            $object->setName(null);
        }
        if (\array_key_exists('serviceName', $data) && $data['serviceName'] !== null) {
            $object->setServiceName($data['serviceName']);
            unset($data['serviceName']);
        }
        elseif (\array_key_exists('serviceName', $data) && $data['serviceName'] === null) {
            $object->setServiceName(null);
        }
        if (\array_key_exists('type', $data) && $data['type'] !== null) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        elseif (\array_key_exists('type', $data) && $data['type'] === null) {
            $object->setType(null);
        }
        if (\array_key_exists('vatIntraCommunityNumber', $data) && $data['vatIntraCommunityNumber'] !== null) {
            $object->setVatIntraCommunityNumber($data['vatIntraCommunityNumber']);
            unset($data['vatIntraCommunityNumber']);
        }
        elseif (\array_key_exists('vatIntraCommunityNumber', $data) && $data['vatIntraCommunityNumber'] === null) {
            $object->setVatIntraCommunityNumber(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('legalCode') && null !== $data->getLegalCode()) {
            $dataArray['legalCode'] = $data->getLegalCode();
        }
        if ($data->isInitialized('name') && null !== $data->getName()) {
            $dataArray['name'] = $data->getName();
        }
        if ($data->isInitialized('serviceName') && null !== $data->getServiceName()) {
            $dataArray['serviceName'] = $data->getServiceName();
        }
        if ($data->isInitialized('type') && null !== $data->getType()) {
            $dataArray['type'] = $data->getType();
        }
        if ($data->isInitialized('vatIntraCommunityNumber') && null !== $data->getVatIntraCommunityNumber()) {
            $dataArray['vatIntraCommunityNumber'] = $data->getVatIntraCommunityNumber();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Cam\Model\NullableCompanyDetailRequest::class => false];
    }
}