<?php

namespace NoahVet\Reef\Cam\Endpoint;

class UpdateOneContact extends \NoahVet\Reef\Cam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Cam\Runtime\Client\Endpoint
{
    protected $id;
    /**
     * Update a Contact by ID.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Cam\Model\SchemasContactRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(string $id, \NoahVet\Reef\Cam\Model\SchemasContactRequest $requestBody, array $headerParameters = [])
    {
        $this->id = $id;
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Cam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'PATCH';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/v1/contacts/{id}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Cam\Model\SchemasContactRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneContactBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneContactNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneContactConflictException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneContactInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasContactResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Cam\\Model\\SchemasContactResponse', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Cam\Exception\UpdateOneContactBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Cam\Exception\UpdateOneContactNotFoundException($response);
        }
        if (409 === $status) {
            throw new \NoahVet\Reef\Cam\Exception\UpdateOneContactConflictException($response);
        }
        if (500 === $status) {
            throw new \NoahVet\Reef\Cam\Exception\UpdateOneContactInternalServerErrorException($response);
        }
        throw new \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}