<?php

namespace NoahVet\Reef\Cam\Endpoint;

class DeleteOnePetBreedExternalLink extends \NoahVet\Reef\Cam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Cam\Runtime\Client\Endpoint
{
    protected $id;
    /**
     * Delete a Pet Breed External Link.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(string $id, array $headerParameters = [])
    {
        $this->id = $id;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Cam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'DELETE';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/v1/pet_breed_external_links/{id}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalLinkBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalLinkNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalLinkInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (204 === $status) {
            return null;
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalLinkBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalLinkNotFoundException($response);
        }
        if (500 === $status) {
            throw new \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalLinkInternalServerErrorException($response);
        }
        throw new \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}