<?php

namespace NoahVet\Reef\Cam\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Cam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Cam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class PetProfileResponseItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Cam\Model\PetProfileResponseItem::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Cam\Model\PetProfileResponseItem::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Cam\Model\PetProfileResponseItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('birthDate', $data) && $data['birthDate'] !== null) {
            $object->setBirthDate(\DateTime::createFromFormat('Y-m-d', $data['birthDate'])->setTime(0, 0, 0));
            unset($data['birthDate']);
        }
        elseif (\array_key_exists('birthDate', $data) && $data['birthDate'] === null) {
            $object->setBirthDate(null);
        }
        if (\array_key_exists('freePetBreed', $data) && $data['freePetBreed'] !== null) {
            $object->setFreePetBreed($data['freePetBreed']);
            unset($data['freePetBreed']);
        }
        elseif (\array_key_exists('freePetBreed', $data) && $data['freePetBreed'] === null) {
            $object->setFreePetBreed(null);
        }
        if (\array_key_exists('gender', $data) && $data['gender'] !== null) {
            $object->setGender($data['gender']);
            unset($data['gender']);
        }
        elseif (\array_key_exists('gender', $data) && $data['gender'] === null) {
            $object->setGender(null);
        }
        if (\array_key_exists('name', $data) && $data['name'] !== null) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        elseif (\array_key_exists('name', $data) && $data['name'] === null) {
            $object->setName(null);
        }
        if (\array_key_exists('pet', $data)) {
            $object->setPet($this->denormalizer->denormalize($data['pet'], \NoahVet\Reef\Cam\Model\IdResponse::class, 'json', $context));
            unset($data['pet']);
        }
        if (\array_key_exists('petBreed', $data) && $data['petBreed'] !== null) {
            $object->setPetBreed($this->denormalizer->denormalize($data['petBreed'], \NoahVet\Reef\Cam\Model\NullableIdResponse::class, 'json', $context));
            unset($data['petBreed']);
        }
        elseif (\array_key_exists('petBreed', $data) && $data['petBreed'] === null) {
            $object->setPetBreed(null);
        }
        if (\array_key_exists('profilePicture', $data) && $data['profilePicture'] !== null) {
            $object->setProfilePicture($this->denormalizer->denormalize($data['profilePicture'], \NoahVet\Reef\Cam\Model\NullableIdResponse::class, 'json', $context));
            unset($data['profilePicture']);
        }
        elseif (\array_key_exists('profilePicture', $data) && $data['profilePicture'] === null) {
            $object->setProfilePicture(null);
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['birthDate'] = $data->getBirthDate()->format('Y-m-d');
        $dataArray['freePetBreed'] = $data->getFreePetBreed();
        $dataArray['gender'] = $data->getGender();
        $dataArray['name'] = $data->getName();
        $dataArray['pet'] = $this->normalizer->normalize($data->getPet(), 'json', $context);
        $dataArray['petBreed'] = $this->normalizer->normalize($data->getPetBreed(), 'json', $context);
        $dataArray['profilePicture'] = $this->normalizer->normalize($data->getProfilePicture(), 'json', $context);
        $dataArray['type'] = $data->getType();
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Cam\Model\PetProfileResponseItem::class => false];
    }
}