<?php

namespace NoahVet\Reef\Cam\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Cam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Cam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class PetResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Cam\Model\PetResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Cam\Model\PetResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Cam\Model\PetResponse();
        if (\array_key_exists('isAnonymous', $data) && \is_int($data['isAnonymous'])) {
            $data['isAnonymous'] = (bool) $data['isAnonymous'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('code', $data)) {
            $object->setCode($data['code']);
            unset($data['code']);
        }
        if (\array_key_exists('isAnonymous', $data)) {
            $object->setIsAnonymous($data['isAnonymous']);
            unset($data['isAnonymous']);
        }
        if (\array_key_exists('microchips', $data)) {
            $values = [];
            foreach ($data['microchips'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Cam\Model\PetResponseMicrochipsItem::class, 'json', $context);
            }
            $object->setMicrochips($values);
            unset($data['microchips']);
        }
        if (\array_key_exists('name', $data) && $data['name'] !== null) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        elseif (\array_key_exists('name', $data) && $data['name'] === null) {
            $object->setName(null);
        }
        if (\array_key_exists('passportNumber', $data) && $data['passportNumber'] !== null) {
            $object->setPassportNumber($data['passportNumber']);
            unset($data['passportNumber']);
        }
        elseif (\array_key_exists('passportNumber', $data) && $data['passportNumber'] === null) {
            $object->setPassportNumber(null);
        }
        if (\array_key_exists('tattoo', $data) && $data['tattoo'] !== null) {
            $object->setTattoo($this->denormalizer->denormalize($data['tattoo'], \NoahVet\Reef\Cam\Model\PetResponseTattoo::class, 'json', $context));
            unset($data['tattoo']);
        }
        elseif (\array_key_exists('tattoo', $data) && $data['tattoo'] === null) {
            $object->setTattoo(null);
        }
        if (\array_key_exists('specie', $data)) {
            $object->setSpecie($this->denormalizer->denormalize($data['specie'], \NoahVet\Reef\Cam\Model\IdResponse::class, 'json', $context));
            unset($data['specie']);
        }
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['code'] = $data->getCode();
        $dataArray['isAnonymous'] = $data->getIsAnonymous();
        $values = [];
        foreach ($data->getMicrochips() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $dataArray['microchips'] = $values;
        $dataArray['name'] = $data->getName();
        $dataArray['passportNumber'] = $data->getPassportNumber();
        $dataArray['tattoo'] = $this->normalizer->normalize($data->getTattoo(), 'json', $context);
        $dataArray['specie'] = $this->normalizer->normalize($data->getSpecie(), 'json', $context);
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Cam\Model\PetResponse::class => false];
    }
}