<?php

namespace NoahVet\Reef\Cam\Model;

class PetBreedRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $specie;
    /**
     * Translation - Pet Breed Request Model
     *
     * @var PetBreedRequestModel
     */
    protected $translations;
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getSpecie() : IdRequest
    {
        return $this->specie;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $specie
     *
     * @return self
     */
    public function setSpecie(IdRequest $specie) : self
    {
        $this->initialized['specie'] = true;
        $this->specie = $specie;
        return $this;
    }
    /**
     * Translation - Pet Breed Request Model
     *
     * @return PetBreedRequestModel
     */
    public function getTranslations() : PetBreedRequestModel
    {
        return $this->translations;
    }
    /**
     * Translation - Pet Breed Request Model
     *
     * @param PetBreedRequestModel $translations
     *
     * @return self
     */
    public function setTranslations(PetBreedRequestModel $translations) : self
    {
        $this->initialized['translations'] = true;
        $this->translations = $translations;
        return $this;
    }
}