<?php

namespace NoahVet\Reef\Cam\Endpoint;

class UpdateOneCustomerProfile extends \NoahVet\Reef\Cam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Cam\Runtime\Client\Endpoint
{
    protected $id;
    /**
     * Update a Customer Profile by ID.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Cam\Model\SchemasCustomerProfileRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(string $id, \NoahVet\Reef\Cam\Model\SchemasCustomerProfileRequest $requestBody, array $headerParameters = [])
    {
        $this->id = $id;
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Cam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'PATCH';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/v1/customer_profiles/{id}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Cam\Model\SchemasCustomerProfileRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileConflictException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasCustomerProfileResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Cam\\Model\\SchemasCustomerProfileResponse', 'json');
        }
        if (is_null($contentType) === false && (400 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileBadRequestException($response);
        }
        if (is_null($contentType) === false && (404 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileNotFoundException($response);
        }
        if (is_null($contentType) === false && (409 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileConflictException($response);
        }
        if (is_null($contentType) === false && (500 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileInternalServerErrorException($response);
        }
        throw new \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}