<?php

namespace NoahVet\Reef\Cam\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Cam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Cam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class SchemasPetRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Cam\Model\SchemasPetRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Cam\Model\SchemasPetRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Cam\Model\SchemasPetRequest();
        if (\array_key_exists('isAnonymous', $data) && \is_int($data['isAnonymous'])) {
            $data['isAnonymous'] = (bool) $data['isAnonymous'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('isAnonymous', $data) && $data['isAnonymous'] !== null) {
            $object->setIsAnonymous($data['isAnonymous']);
            unset($data['isAnonymous']);
        }
        elseif (\array_key_exists('isAnonymous', $data) && $data['isAnonymous'] === null) {
            $object->setIsAnonymous(null);
        }
        if (\array_key_exists('name', $data) && $data['name'] !== null) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        elseif (\array_key_exists('name', $data) && $data['name'] === null) {
            $object->setName(null);
        }
        if (\array_key_exists('passportNumber', $data) && $data['passportNumber'] !== null) {
            $object->setPassportNumber($data['passportNumber']);
            unset($data['passportNumber']);
        }
        elseif (\array_key_exists('passportNumber', $data) && $data['passportNumber'] === null) {
            $object->setPassportNumber(null);
        }
        if (\array_key_exists('tattoo', $data) && $data['tattoo'] !== null) {
            $object->setTattoo($this->denormalizer->denormalize($data['tattoo'], \NoahVet\Reef\Cam\Model\SchemasPetRequestTattoo::class, 'json', $context));
            unset($data['tattoo']);
        }
        elseif (\array_key_exists('tattoo', $data) && $data['tattoo'] === null) {
            $object->setTattoo(null);
        }
        if (\array_key_exists('specie', $data) && $data['specie'] !== null) {
            $object->setSpecie($this->denormalizer->denormalize($data['specie'], \NoahVet\Reef\Cam\Model\NullableIdRequest::class, 'json', $context));
            unset($data['specie']);
        }
        elseif (\array_key_exists('specie', $data) && $data['specie'] === null) {
            $object->setSpecie(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('isAnonymous') && null !== $data->getIsAnonymous()) {
            $dataArray['isAnonymous'] = $data->getIsAnonymous();
        }
        if ($data->isInitialized('name') && null !== $data->getName()) {
            $dataArray['name'] = $data->getName();
        }
        if ($data->isInitialized('passportNumber') && null !== $data->getPassportNumber()) {
            $dataArray['passportNumber'] = $data->getPassportNumber();
        }
        if ($data->isInitialized('tattoo') && null !== $data->getTattoo()) {
            $dataArray['tattoo'] = $this->normalizer->normalize($data->getTattoo(), 'json', $context);
        }
        if ($data->isInitialized('specie') && null !== $data->getSpecie()) {
            $dataArray['specie'] = $this->normalizer->normalize($data->getSpecie(), 'json', $context);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Cam\Model\SchemasPetRequest::class => false];
    }
}