<?php

namespace NoahVet\Reef\Cam\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Cam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Cam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class SchemasContactRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Cam\Model\SchemasContactRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Cam\Model\SchemasContactRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Cam\Model\SchemasContactRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('addressSupplement', $data) && $data['addressSupplement'] !== null) {
            $object->setAddressSupplement($data['addressSupplement']);
            unset($data['addressSupplement']);
        }
        elseif (\array_key_exists('addressSupplement', $data) && $data['addressSupplement'] === null) {
            $object->setAddressSupplement(null);
        }
        if (\array_key_exists('city', $data) && $data['city'] !== null) {
            $object->setCity($data['city']);
            unset($data['city']);
        }
        elseif (\array_key_exists('city', $data) && $data['city'] === null) {
            $object->setCity(null);
        }
        if (\array_key_exists('comment', $data) && $data['comment'] !== null) {
            $object->setComment($data['comment']);
            unset($data['comment']);
        }
        elseif (\array_key_exists('comment', $data) && $data['comment'] === null) {
            $object->setComment(null);
        }
        if (\array_key_exists('companyDetail', $data) && $data['companyDetail'] !== null) {
            $object->setCompanyDetail($this->denormalizer->denormalize($data['companyDetail'], \NoahVet\Reef\Cam\Model\NullableCompanyDetailRequest::class, 'json', $context));
            unset($data['companyDetail']);
        }
        elseif (\array_key_exists('companyDetail', $data) && $data['companyDetail'] === null) {
            $object->setCompanyDetail(null);
        }
        if (\array_key_exists('country', $data) && $data['country'] !== null) {
            $object->setCountry($data['country']);
            unset($data['country']);
        }
        elseif (\array_key_exists('country', $data) && $data['country'] === null) {
            $object->setCountry(null);
        }
        if (\array_key_exists('department', $data) && $data['department'] !== null) {
            $object->setDepartment($data['department']);
            unset($data['department']);
        }
        elseif (\array_key_exists('department', $data) && $data['department'] === null) {
            $object->setDepartment(null);
        }
        if (\array_key_exists('email', $data) && $data['email'] !== null) {
            $object->setEmail($data['email']);
            unset($data['email']);
        }
        elseif (\array_key_exists('email', $data) && $data['email'] === null) {
            $object->setEmail(null);
        }
        if (\array_key_exists('entitled', $data) && $data['entitled'] !== null) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        elseif (\array_key_exists('entitled', $data) && $data['entitled'] === null) {
            $object->setEntitled(null);
        }
        if (\array_key_exists('geolocation', $data) && $data['geolocation'] !== null) {
            $object->setGeolocation($this->denormalizer->denormalize($data['geolocation'], \NoahVet\Reef\Cam\Model\NullableGeolocationRequest::class, 'json', $context));
            unset($data['geolocation']);
        }
        elseif (\array_key_exists('geolocation', $data) && $data['geolocation'] === null) {
            $object->setGeolocation(null);
        }
        if (\array_key_exists('phoneNumber', $data) && $data['phoneNumber'] !== null) {
            $object->setPhoneNumber($data['phoneNumber']);
            unset($data['phoneNumber']);
        }
        elseif (\array_key_exists('phoneNumber', $data) && $data['phoneNumber'] === null) {
            $object->setPhoneNumber(null);
        }
        if (\array_key_exists('postalCode', $data) && $data['postalCode'] !== null) {
            $object->setPostalCode($data['postalCode']);
            unset($data['postalCode']);
        }
        elseif (\array_key_exists('postalCode', $data) && $data['postalCode'] === null) {
            $object->setPostalCode(null);
        }
        if (\array_key_exists('postBoxNumber', $data) && $data['postBoxNumber'] !== null) {
            $object->setPostBoxNumber($data['postBoxNumber']);
            unset($data['postBoxNumber']);
        }
        elseif (\array_key_exists('postBoxNumber', $data) && $data['postBoxNumber'] === null) {
            $object->setPostBoxNumber(null);
        }
        if (\array_key_exists('recipientIdentity', $data) && $data['recipientIdentity'] !== null) {
            $object->setRecipientIdentity($data['recipientIdentity']);
            unset($data['recipientIdentity']);
        }
        elseif (\array_key_exists('recipientIdentity', $data) && $data['recipientIdentity'] === null) {
            $object->setRecipientIdentity(null);
        }
        if (\array_key_exists('region', $data) && $data['region'] !== null) {
            $object->setRegion($data['region']);
            unset($data['region']);
        }
        elseif (\array_key_exists('region', $data) && $data['region'] === null) {
            $object->setRegion(null);
        }
        if (\array_key_exists('streetName', $data) && $data['streetName'] !== null) {
            $object->setStreetName($data['streetName']);
            unset($data['streetName']);
        }
        elseif (\array_key_exists('streetName', $data) && $data['streetName'] === null) {
            $object->setStreetName(null);
        }
        if (\array_key_exists('streetNumber', $data) && $data['streetNumber'] !== null) {
            $object->setStreetNumber($data['streetNumber']);
            unset($data['streetNumber']);
        }
        elseif (\array_key_exists('streetNumber', $data) && $data['streetNumber'] === null) {
            $object->setStreetNumber(null);
        }
        if (\array_key_exists('type', $data) && $data['type'] !== null) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        elseif (\array_key_exists('type', $data) && $data['type'] === null) {
            $object->setType(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('addressSupplement') && null !== $data->getAddressSupplement()) {
            $dataArray['addressSupplement'] = $data->getAddressSupplement();
        }
        if ($data->isInitialized('city') && null !== $data->getCity()) {
            $dataArray['city'] = $data->getCity();
        }
        if ($data->isInitialized('comment') && null !== $data->getComment()) {
            $dataArray['comment'] = $data->getComment();
        }
        if ($data->isInitialized('companyDetail') && null !== $data->getCompanyDetail()) {
            $dataArray['companyDetail'] = $this->normalizer->normalize($data->getCompanyDetail(), 'json', $context);
        }
        if ($data->isInitialized('country') && null !== $data->getCountry()) {
            $dataArray['country'] = $data->getCountry();
        }
        if ($data->isInitialized('department') && null !== $data->getDepartment()) {
            $dataArray['department'] = $data->getDepartment();
        }
        if ($data->isInitialized('email') && null !== $data->getEmail()) {
            $dataArray['email'] = $data->getEmail();
        }
        if ($data->isInitialized('entitled') && null !== $data->getEntitled()) {
            $dataArray['entitled'] = $data->getEntitled();
        }
        if ($data->isInitialized('geolocation') && null !== $data->getGeolocation()) {
            $dataArray['geolocation'] = $this->normalizer->normalize($data->getGeolocation(), 'json', $context);
        }
        if ($data->isInitialized('phoneNumber') && null !== $data->getPhoneNumber()) {
            $dataArray['phoneNumber'] = $data->getPhoneNumber();
        }
        if ($data->isInitialized('postalCode') && null !== $data->getPostalCode()) {
            $dataArray['postalCode'] = $data->getPostalCode();
        }
        if ($data->isInitialized('postBoxNumber') && null !== $data->getPostBoxNumber()) {
            $dataArray['postBoxNumber'] = $data->getPostBoxNumber();
        }
        if ($data->isInitialized('recipientIdentity') && null !== $data->getRecipientIdentity()) {
            $dataArray['recipientIdentity'] = $data->getRecipientIdentity();
        }
        if ($data->isInitialized('region') && null !== $data->getRegion()) {
            $dataArray['region'] = $data->getRegion();
        }
        if ($data->isInitialized('streetName') && null !== $data->getStreetName()) {
            $dataArray['streetName'] = $data->getStreetName();
        }
        if ($data->isInitialized('streetNumber') && null !== $data->getStreetNumber()) {
            $dataArray['streetNumber'] = $data->getStreetNumber();
        }
        if ($data->isInitialized('type') && null !== $data->getType()) {
            $dataArray['type'] = $data->getType();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Cam\Model\SchemasContactRequest::class => false];
    }
}