<?php

namespace NoahVet\Reef\Cam\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Cam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Cam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class PetBreedTagRequestModelNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Cam\Model\PetBreedTagRequestModel::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Cam\Model\PetBreedTagRequestModel::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Cam\Model\PetBreedTagRequestModel();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('en_GB', $data)) {
            $object->setEnGB($this->denormalizer->denormalize($data['en_GB'], \NoahVet\Reef\Cam\Model\PetBreedTagRequestModelEnGB::class, 'json', $context));
            unset($data['en_GB']);
        }
        if (\array_key_exists('fr_FR', $data)) {
            $object->setFrFR($this->denormalizer->denormalize($data['fr_FR'], \NoahVet\Reef\Cam\Model\PetBreedTagRequestModelFrFR::class, 'json', $context));
            unset($data['fr_FR']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['en_GB'] = $this->normalizer->normalize($data->getEnGB(), 'json', $context);
        $dataArray['fr_FR'] = $this->normalizer->normalize($data->getFrFR(), 'json', $context);
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Cam\Model\PetBreedTagRequestModel::class => false];
    }
}