<?php

namespace NoahVet\Reef\Cam\Endpoint;

class PostPetBreedLabelling extends \NoahVet\Reef\Cam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Cam\Runtime\Client\Endpoint
{
    /**
     * Create a PetBreedLabelling.
     *
     * @param \NoahVet\Reef\Cam\Model\PetBreedLabellingRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(\NoahVet\Reef\Cam\Model\PetBreedLabellingRequest $requestBody, array $headerParameters = [])
    {
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Cam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'POST';
    }
    public function getUri() : string
    {
        return '/v1/pet_breed_labellings';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Cam\Model\PetBreedLabellingRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedLabellingBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedLabellingInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasPetBreedLabellingResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (201 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Cam\\Model\\SchemasPetBreedLabellingResponse', 'json');
        }
        if (is_null($contentType) === false && (400 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Cam\Exception\PostPetBreedLabellingBadRequestException($response);
        }
        if (is_null($contentType) === false && (500 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Cam\Exception\PostPetBreedLabellingInternalServerErrorException($response);
        }
        throw new \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}