<?php

namespace NoahVet\Reef\Cam;

class Client extends \NoahVet\Reef\Cam\Runtime\Client\Client
{
    /**
    * List Contact.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $customerId[] Filter by customerId.
    *     @var array $customerProfileId[] Filter by customerProfileId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Cam\Exception\GetAllContactBadRequestException
    * @throws \NoahVet\Reef\Cam\Exception\GetAllContactInternalServerErrorException
    * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Cam\Model\ContactResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllContact(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\GetAllContact($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a Contact.
     *
     * @param \NoahVet\Reef\Cam\Model\ContactRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostContactBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostContactNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\PostContactConflictException
     * @throws \NoahVet\Reef\Cam\Exception\PostContactInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasContactResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postContact(\NoahVet\Reef\Cam\Model\ContactRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostContact($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Contact.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOneContactBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOneContactNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOneContactInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneContact(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\DeleteOneContact($id, $headerParameters), $fetch);
    }
    /**
     * Update a Contact by ID.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Cam\Model\SchemasContactRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneContactBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneContactNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneContactConflictException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneContactInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasContactResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneContact(string $id, \NoahVet\Reef\Cam\Model\SchemasContactRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\UpdateOneContact($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Customer.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Cam\Exception\GetAllCustomerBadRequestException
    * @throws \NoahVet\Reef\Cam\Exception\GetAllCustomerInternalServerErrorException
    * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Cam\Model\CustomerResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllCustomer(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\GetAllCustomer($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Update a Customer by ID.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Cam\Model\CustomerRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneCustomerBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneCustomerNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneCustomerInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasCustomerResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneCustomer(string $id, \NoahVet\Reef\Cam\Model\CustomerRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\UpdateOneCustomer($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Customer Profiles.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $customerId[] Filter by customerId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Cam\Exception\GetAllCustomerProfileBadRequestException
    * @throws \NoahVet\Reef\Cam\Exception\GetAllCustomerProfileInternalServerErrorException
    * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Cam\Model\CustomerProfileResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllCustomerProfile(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\GetAllCustomerProfile($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create a Customer Profile.
     *
     * @param \NoahVet\Reef\Cam\Model\CustomerProfileRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostCustomerProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostCustomerProfileNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\PostCustomerProfileConflictException
     * @throws \NoahVet\Reef\Cam\Exception\PostCustomerProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasCustomerProfileResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postCustomerProfile(\NoahVet\Reef\Cam\Model\CustomerProfileRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostCustomerProfile($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Customer Profile.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOneCustomerProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOneCustomerProfileNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOneCustomerProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOneCustomerProfile(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\DeleteOneCustomerProfile($id, $headerParameters), $fetch);
    }
    /**
     * Update a Customer Profile by ID.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Cam\Model\SchemasCustomerProfileRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileConflictException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOneCustomerProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasCustomerProfileResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneCustomerProfile(string $id, \NoahVet\Reef\Cam\Model\SchemasCustomerProfileRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\UpdateOneCustomerProfile($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Pets.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetBadRequestException
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetInternalServerErrorException
    * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Cam\Model\PetResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllPet(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\GetAllPet($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create an Pet.
     *
     * @param \NoahVet\Reef\Cam\Model\PetRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasPetResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postPet(\NoahVet\Reef\Cam\Model\PetRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostPet($requestBody, $headerParameters), $fetch);
    }
    /**
     * Update a Pet by ID.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Cam\Model\SchemasPetRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasPetResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOnePet(string $id, \NoahVet\Reef\Cam\Model\SchemasPetRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\UpdateOnePet($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Pet Breeds.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $code[] Filter by code.
    *     @var array $name[] Filter by name.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetBreedBadRequestException
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetBreedInternalServerErrorException
    * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Cam\Model\PetBreedResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllPetBreed(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\GetAllPetBreed($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create an PetBreed.
     *
     * @param \NoahVet\Reef\Cam\Model\PetBreedRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasPetBreedResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postPetBreed(\NoahVet\Reef\Cam\Model\PetBreedRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostPetBreed($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Pet Breed.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOnePetBreed(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\DeleteOnePetBreed($id, $headerParameters), $fetch);
    }
    /**
    * List Pet Breed External Links.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $petBreedId[] Filter by petBreedId.
    *     @var array $externalRefId[] Filter by externalRefId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetBreedExternalLinkBadRequestException
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetBreedExternalLinkInternalServerErrorException
    * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Cam\Model\PetBreedExternalLinkResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllPetBreedExternalLink(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\GetAllPetBreedExternalLink($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create an PetBreedExternalLink.
     *
     * @param \NoahVet\Reef\Cam\Model\PetBreedExternalLinkRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedExternalLinkBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedExternalLinkInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasPetBreedExternalLinkResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postPetBreedExternalLink(\NoahVet\Reef\Cam\Model\PetBreedExternalLinkRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostPetBreedExternalLink($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Pet Breed External Link.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalLinkBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalLinkNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalLinkInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOnePetBreedExternalLink(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\DeleteOnePetBreedExternalLink($id, $headerParameters), $fetch);
    }
    /**
    * List Pet Breed External Refs.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $name[] Filter by name.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetBreedExternalRefBadRequestException
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetBreedExternalRefInternalServerErrorException
    * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Cam\Model\PetBreedExternalRefResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllPetBreedExternalRef(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\GetAllPetBreedExternalRef($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create an PetBreedExternalRef.
     *
     * @param \NoahVet\Reef\Cam\Model\PetBreedExternalRefRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedExternalRefBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedExternalRefInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasPetBreedExternalRefResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postPetBreedExternalRef(\NoahVet\Reef\Cam\Model\PetBreedExternalRefRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostPetBreedExternalRef($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Pet Breed External Ref.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalRefBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalRefNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedExternalRefInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOnePetBreedExternalRef(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\DeleteOnePetBreedExternalRef($id, $headerParameters), $fetch);
    }
    /**
    * List Pet Breed Labellings.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $petBreedId[] Filter by petBreedId.
    *     @var array $tagId[] Filter by tagId.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetBreedLabellingBadRequestException
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetBreedLabellingInternalServerErrorException
    * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Cam\Model\PetBreedLabellingResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllPetBreedLabelling(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\GetAllPetBreedLabelling($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create an PetBreedLabelling.
     *
     * @param \NoahVet\Reef\Cam\Model\PetBreedLabellingRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedLabellingBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedLabellingInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasPetBreedLabellingResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postPetBreedLabelling(\NoahVet\Reef\Cam\Model\PetBreedLabellingRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostPetBreedLabelling($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Pet Breed Labelling.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedLabellingBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedLabellingNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedLabellingInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOnePetBreedLabelling(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\DeleteOnePetBreedLabelling($id, $headerParameters), $fetch);
    }
    /**
    * List Pet Breed Tags.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $name[] Filter by name.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetBreedTagBadRequestException
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetBreedTagInternalServerErrorException
    * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Cam\Model\PetBreedTagResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllPetBreedTag(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\GetAllPetBreedTag($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create an PetBreedTag.
     *
     * @param \NoahVet\Reef\Cam\Model\PetBreedTagRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedTagBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedTagInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasPetBreedTagResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postPetBreedTag(\NoahVet\Reef\Cam\Model\PetBreedTagRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostPetBreedTag($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Pet Breed Tag.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedTagBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedTagNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetBreedTagInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOnePetBreedTag(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\DeleteOnePetBreedTag($id, $headerParameters), $fetch);
    }
    /**
     * Create an Pet Microchip.
     *
     * @param \NoahVet\Reef\Cam\Model\PetMicrochipRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostPetMicrochipBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetMicrochipInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\PetMicrochipResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postPetMicrochip(\NoahVet\Reef\Cam\Model\PetMicrochipRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostPetMicrochip($requestBody, $headerParameters), $fetch);
    }
    /**
     * Delete a Pet Microchip.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetMicrochipBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetMicrochipNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\DeleteOnePetMicrochipInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function deleteOnePetMicrochip(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\DeleteOnePetMicrochip($id, $headerParameters), $fetch);
    }
    /**
    * List Pet Profiles.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $type[] Filter by pet profile type.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetProfileBadRequestException
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetProfileInternalServerErrorException
    * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
    *
    * @return null|\Psr\Http\Message\ResponseInterface
    */
    public function getAllPetProfile(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\GetAllPetProfile($queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create an PetCustomerProfile.
     *
     * @param \NoahVet\Reef\Cam\Model\PetProfileRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostPetCustomerProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetCustomerProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\PetProfileResponseItem[]|\Psr\Http\Message\ResponseInterface
     */
    public function postPetCustomerProfile(\NoahVet\Reef\Cam\Model\PetProfileRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostPetCustomerProfile($requestBody, $headerParameters), $fetch);
    }
    /**
     * Update a Pet Customer Profile by ID.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetCustomerProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetCustomerProfileNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetCustomerProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\PetProfileResponseItem[]|\Psr\Http\Message\ResponseInterface
     */
    public function updateOnePetCustomerProfile(string $id, \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\UpdateOnePetCustomerProfile($id, $requestBody, $headerParameters), $fetch);
    }
    /**
     * Create an PetGhostProfile.
     *
     * @param \NoahVet\Reef\Cam\Model\PetProfileRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostPetGhostProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetGhostProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\PetProfileResponseItem[]|\Psr\Http\Message\ResponseInterface
     */
    public function postPetGhostProfile(\NoahVet\Reef\Cam\Model\PetProfileRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostPetGhostProfile($requestBody, $headerParameters), $fetch);
    }
    /**
     * Update a Pet Ghost Profile by ID.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetGhostProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetGhostProfileNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetGhostProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\PetProfileResponseItem[]|\Psr\Http\Message\ResponseInterface
     */
    public function updateOnePetGhostProfile(string $id, \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\UpdateOnePetGhostProfile($id, $requestBody, $headerParameters), $fetch);
    }
    /**
     * Create an PetPatientProfile.
     *
     * @param \NoahVet\Reef\Cam\Model\PetProfileRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostPetPatientProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetPatientProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\PetProfileResponseItem[]|\Psr\Http\Message\ResponseInterface
     */
    public function postPetPatientProfile(\NoahVet\Reef\Cam\Model\PetProfileRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostPetPatientProfile($requestBody, $headerParameters), $fetch);
    }
    /**
     * Update a Pet Patient Profile by ID.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetPatientProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetPatientProfileNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetPatientProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\PetProfileResponseItem[]|\Psr\Http\Message\ResponseInterface
     */
    public function updateOnePetPatientProfile(string $id, \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\UpdateOnePetPatientProfile($id, $requestBody, $headerParameters), $fetch);
    }
    /**
     * Create an PetPublicProfile.
     *
     * @param \NoahVet\Reef\Cam\Model\PetProfileRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\PostPetPublicProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetPublicProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\PetProfileResponseItem[]|\Psr\Http\Message\ResponseInterface
     */
    public function postPetPublicProfile(\NoahVet\Reef\Cam\Model\PetProfileRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\PostPetPublicProfile($requestBody, $headerParameters), $fetch);
    }
    /**
     * Update a Pet Public Profile by ID.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetPublicProfileBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetPublicProfileNotFoundException
     * @throws \NoahVet\Reef\Cam\Exception\UpdateOnePetPublicProfileInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\PetProfileResponseItem[]|\Psr\Http\Message\ResponseInterface
     */
    public function updateOnePetPublicProfile(string $id, \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\UpdateOnePetPublicProfile($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List Pet Species.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $name[] Filter by name.
    *     @var array $category[] Filter by category.
    *     @var array $code[] Filter by code.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetSpecieBadRequestException
    * @throws \NoahVet\Reef\Cam\Exception\GetAllPetSpecieInternalServerErrorException
    * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\Reef\Cam\Model\PetSpecieResponseItem[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllPetSpecie(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Cam\Endpoint\GetAllPetSpecie($queryParameters, $headerParameters), $fetch);
    }
    public static function create($httpClient = null, array $additionalPlugins = [], array $additionalNormalizers = [])
    {
        if (null === $httpClient) {
            $httpClient = \Http\Discovery\Psr18ClientDiscovery::find();
            $plugins = [];
            if (count($additionalPlugins) > 0) {
                $plugins = array_merge($plugins, $additionalPlugins);
            }
            $httpClient = new \Http\Client\Common\PluginClient($httpClient, $plugins);
        }
        $requestFactory = \Http\Discovery\Psr17FactoryDiscovery::findRequestFactory();
        $streamFactory = \Http\Discovery\Psr17FactoryDiscovery::findStreamFactory();
        $normalizers = [new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \NoahVet\Reef\Cam\Normalizer\JaneObjectNormalizer()];
        if (count($additionalNormalizers) > 0) {
            $normalizers = array_merge($normalizers, $additionalNormalizers);
        }
        $serializer = new \Symfony\Component\Serializer\Serializer($normalizers, [new \Symfony\Component\Serializer\Encoder\JsonEncoder(new \Symfony\Component\Serializer\Encoder\JsonEncode(), new \Symfony\Component\Serializer\Encoder\JsonDecode(['json_decode_associative' => true]))]);
        return new static($httpClient, $requestFactory, $serializer, $streamFactory);
    }
}