<?php

namespace NoahVet\Reef\Cam\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Cam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Cam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class SchemasPetProfileRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('birthDate', $data) && $data['birthDate'] !== null) {
            $object->setBirthDate(\DateTime::createFromFormat('Y-m-d', $data['birthDate'])->setTime(0, 0, 0));
            unset($data['birthDate']);
        }
        elseif (\array_key_exists('birthDate', $data) && $data['birthDate'] === null) {
            $object->setBirthDate(null);
        }
        if (\array_key_exists('deathDate', $data) && $data['deathDate'] !== null) {
            $object->setDeathDate(\DateTime::createFromFormat('Y-m-d', $data['deathDate'])->setTime(0, 0, 0));
            unset($data['deathDate']);
        }
        elseif (\array_key_exists('deathDate', $data) && $data['deathDate'] === null) {
            $object->setDeathDate(null);
        }
        if (\array_key_exists('deathReason', $data) && $data['deathReason'] !== null) {
            $object->setDeathReason($data['deathReason']);
            unset($data['deathReason']);
        }
        elseif (\array_key_exists('deathReason', $data) && $data['deathReason'] === null) {
            $object->setDeathReason(null);
        }
        if (\array_key_exists('freePetBreed', $data) && $data['freePetBreed'] !== null) {
            $object->setFreePetBreed($data['freePetBreed']);
            unset($data['freePetBreed']);
        }
        elseif (\array_key_exists('freePetBreed', $data) && $data['freePetBreed'] === null) {
            $object->setFreePetBreed(null);
        }
        if (\array_key_exists('gender', $data) && $data['gender'] !== null) {
            $object->setGender($data['gender']);
            unset($data['gender']);
        }
        elseif (\array_key_exists('gender', $data) && $data['gender'] === null) {
            $object->setGender(null);
        }
        if (\array_key_exists('name', $data) && $data['name'] !== null) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        elseif (\array_key_exists('name', $data) && $data['name'] === null) {
            $object->setName(null);
        }
        if (\array_key_exists('petBreed', $data) && $data['petBreed'] !== null) {
            $object->setPetBreed($this->denormalizer->denormalize($data['petBreed'], \NoahVet\Reef\Cam\Model\NullableIdRequest::class, 'json', $context));
            unset($data['petBreed']);
        }
        elseif (\array_key_exists('petBreed', $data) && $data['petBreed'] === null) {
            $object->setPetBreed(null);
        }
        if (\array_key_exists('profilePicture', $data) && $data['profilePicture'] !== null) {
            $object->setProfilePicture($this->denormalizer->denormalize($data['profilePicture'], \NoahVet\Reef\Cam\Model\NullableIdRequest::class, 'json', $context));
            unset($data['profilePicture']);
        }
        elseif (\array_key_exists('profilePicture', $data) && $data['profilePicture'] === null) {
            $object->setProfilePicture(null);
        }
        if (\array_key_exists('weight', $data) && $data['weight'] !== null) {
            $object->setWeight($data['weight']);
            unset($data['weight']);
        }
        elseif (\array_key_exists('weight', $data) && $data['weight'] === null) {
            $object->setWeight(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('birthDate') && null !== $data->getBirthDate()) {
            $dataArray['birthDate'] = $data->getBirthDate()->format('Y-m-d');
        }
        if ($data->isInitialized('deathDate') && null !== $data->getDeathDate()) {
            $dataArray['deathDate'] = $data->getDeathDate()->format('Y-m-d');
        }
        if ($data->isInitialized('deathReason') && null !== $data->getDeathReason()) {
            $dataArray['deathReason'] = $data->getDeathReason();
        }
        if ($data->isInitialized('freePetBreed') && null !== $data->getFreePetBreed()) {
            $dataArray['freePetBreed'] = $data->getFreePetBreed();
        }
        if ($data->isInitialized('gender') && null !== $data->getGender()) {
            $dataArray['gender'] = $data->getGender();
        }
        if ($data->isInitialized('name') && null !== $data->getName()) {
            $dataArray['name'] = $data->getName();
        }
        if ($data->isInitialized('petBreed') && null !== $data->getPetBreed()) {
            $dataArray['petBreed'] = $this->normalizer->normalize($data->getPetBreed(), 'json', $context);
        }
        if ($data->isInitialized('profilePicture') && null !== $data->getProfilePicture()) {
            $dataArray['profilePicture'] = $this->normalizer->normalize($data->getProfilePicture(), 'json', $context);
        }
        if ($data->isInitialized('weight') && null !== $data->getWeight()) {
            $dataArray['weight'] = $data->getWeight();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Cam\Model\SchemasPetProfileRequest::class => false];
    }
}