<?php

namespace NoahVet\Reef\Cam\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Cam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Cam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class PetBreedExternalLinkRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Cam\Model\PetBreedExternalLinkRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Cam\Model\PetBreedExternalLinkRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Cam\Model\PetBreedExternalLinkRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('petBreed', $data)) {
            $object->setPetBreed($this->denormalizer->denormalize($data['petBreed'], \NoahVet\Reef\Cam\Model\IdRequest::class, 'json', $context));
            unset($data['petBreed']);
        }
        if (\array_key_exists('externalRef', $data)) {
            $object->setExternalRef($this->denormalizer->denormalize($data['externalRef'], \NoahVet\Reef\Cam\Model\IdRequest::class, 'json', $context));
            unset($data['externalRef']);
        }
        if (\array_key_exists('sharedId', $data) && $data['sharedId'] !== null) {
            $object->setSharedId($data['sharedId']);
            unset($data['sharedId']);
        }
        elseif (\array_key_exists('sharedId', $data) && $data['sharedId'] === null) {
            $object->setSharedId(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['petBreed'] = $this->normalizer->normalize($data->getPetBreed(), 'json', $context);
        $dataArray['externalRef'] = $this->normalizer->normalize($data->getExternalRef(), 'json', $context);
        if ($data->isInitialized('sharedId') && null !== $data->getSharedId()) {
            $dataArray['sharedId'] = $data->getSharedId();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Cam\Model\PetBreedExternalLinkRequest::class => false];
    }
}