<?php

namespace NoahVet\Reef\Cam\Endpoint;

class PostPetBreedTag extends \NoahVet\Reef\Cam\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Cam\Runtime\Client\Endpoint
{
    /**
     * Create an PetBreedTag.
     *
     * @param \NoahVet\Reef\Cam\Model\PetBreedTagRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(\NoahVet\Reef\Cam\Model\PetBreedTagRequest $requestBody, array $headerParameters = [])
    {
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Cam\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'POST';
    }
    public function getUri() : string
    {
        return '/v1/pet_breed_tags';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Cam\Model\PetBreedTagRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedTagBadRequestException
     * @throws \NoahVet\Reef\Cam\Exception\PostPetBreedTagInternalServerErrorException
     * @throws \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Cam\Model\SchemasPetBreedTagResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (201 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Cam\\Model\\SchemasPetBreedTagResponse', 'json');
        }
        if (is_null($contentType) === false && (400 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Cam\Exception\PostPetBreedTagBadRequestException($response);
        }
        if (is_null($contentType) === false && (500 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Cam\Exception\PostPetBreedTagInternalServerErrorException($response);
        }
        throw new \NoahVet\Reef\Cam\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}