<?php

namespace NoahVet\Reef\Cam\Normalizer;

use NoahVet\Reef\Cam\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Cam\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class JaneObjectNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    protected $normalizers = [
        
        \NoahVet\Reef\Cam\Model\NullableCompanyDetailResponse::class => \NoahVet\Reef\Cam\Normalizer\NullableCompanyDetailResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\IdResponse::class => \NoahVet\Reef\Cam\Normalizer\IdResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\NullableGeolocationResponse::class => \NoahVet\Reef\Cam\Normalizer\NullableGeolocationResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\ContactResponseItem::class => \NoahVet\Reef\Cam\Normalizer\ContactResponseItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\NullableCompanyDetailRequest::class => \NoahVet\Reef\Cam\Normalizer\NullableCompanyDetailRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\IdRequest::class => \NoahVet\Reef\Cam\Normalizer\IdRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\NullableGeolocationRequest::class => \NoahVet\Reef\Cam\Normalizer\NullableGeolocationRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\ContactRequest::class => \NoahVet\Reef\Cam\Normalizer\ContactRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasContactResponse::class => \NoahVet\Reef\Cam\Normalizer\SchemasContactResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasContactRequest::class => \NoahVet\Reef\Cam\Normalizer\SchemasContactRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\CustomerResponseItem::class => \NoahVet\Reef\Cam\Normalizer\CustomerResponseItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\CustomerRequest::class => \NoahVet\Reef\Cam\Normalizer\CustomerRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasCustomerResponse::class => \NoahVet\Reef\Cam\Normalizer\SchemasCustomerResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\NullableIdResponse::class => \NoahVet\Reef\Cam\Normalizer\NullableIdResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\CustomerProfileResponseItem::class => \NoahVet\Reef\Cam\Normalizer\CustomerProfileResponseItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\CustomerProfileRequest::class => \NoahVet\Reef\Cam\Normalizer\CustomerProfileRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasCustomerProfileResponse::class => \NoahVet\Reef\Cam\Normalizer\SchemasCustomerProfileResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\NullableIdRequest::class => \NoahVet\Reef\Cam\Normalizer\NullableIdRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasCustomerProfileRequest::class => \NoahVet\Reef\Cam\Normalizer\SchemasCustomerProfileRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetResponseItem::class => \NoahVet\Reef\Cam\Normalizer\PetResponseItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetResponseItemMicrochipsItem::class => \NoahVet\Reef\Cam\Normalizer\PetResponseItemMicrochipsItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetResponseItemTattoo::class => \NoahVet\Reef\Cam\Normalizer\PetResponseItemTattooNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetRequest::class => \NoahVet\Reef\Cam\Normalizer\PetRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetRequestTattoo::class => \NoahVet\Reef\Cam\Normalizer\PetRequestTattooNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetResponse::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetResponseMicrochipsItem::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetResponseMicrochipsItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetResponseTattoo::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetResponseTattooNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetRequest::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetRequestTattoo::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetRequestTattooNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedResponseItem::class => \NoahVet\Reef\Cam\Normalizer\PetBreedResponseItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedResponseItemAliasesItem::class => \NoahVet\Reef\Cam\Normalizer\PetBreedResponseItemAliasesItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedRequestModel::class => \NoahVet\Reef\Cam\Normalizer\PetBreedRequestModelNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedRequestModelEnGB::class => \NoahVet\Reef\Cam\Normalizer\PetBreedRequestModelEnGBNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedRequestModelEnGBAliasesItem::class => \NoahVet\Reef\Cam\Normalizer\PetBreedRequestModelEnGBAliasesItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedRequestModelFrFR::class => \NoahVet\Reef\Cam\Normalizer\PetBreedRequestModelFrFRNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedRequestModelFrFRAliasesItem::class => \NoahVet\Reef\Cam\Normalizer\PetBreedRequestModelFrFRAliasesItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedRequest::class => \NoahVet\Reef\Cam\Normalizer\PetBreedRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetBreedResponse::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetBreedResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetBreedResponseAliasesItem::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetBreedResponseAliasesItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedExternalLinkResponseItem::class => \NoahVet\Reef\Cam\Normalizer\PetBreedExternalLinkResponseItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedExternalLinkRequest::class => \NoahVet\Reef\Cam\Normalizer\PetBreedExternalLinkRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetBreedExternalLinkResponse::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetBreedExternalLinkResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedExternalRefResponseItem::class => \NoahVet\Reef\Cam\Normalizer\PetBreedExternalRefResponseItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedExternalRefResponseItemCoveredLocales::class => \NoahVet\Reef\Cam\Normalizer\PetBreedExternalRefResponseItemCoveredLocalesNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedExternalRefRequest::class => \NoahVet\Reef\Cam\Normalizer\PetBreedExternalRefRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedExternalRefRequestCoveredLocales::class => \NoahVet\Reef\Cam\Normalizer\PetBreedExternalRefRequestCoveredLocalesNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetBreedExternalRefResponse::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetBreedExternalRefResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetBreedExternalRefResponseCoveredLocales::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetBreedExternalRefResponseCoveredLocalesNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedLabellingResponseItem::class => \NoahVet\Reef\Cam\Normalizer\PetBreedLabellingResponseItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedLabellingRequest::class => \NoahVet\Reef\Cam\Normalizer\PetBreedLabellingRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetBreedLabellingResponse::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetBreedLabellingResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedTagResponseItem::class => \NoahVet\Reef\Cam\Normalizer\PetBreedTagResponseItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedTagRequestModel::class => \NoahVet\Reef\Cam\Normalizer\PetBreedTagRequestModelNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedTagRequestModelEnGB::class => \NoahVet\Reef\Cam\Normalizer\PetBreedTagRequestModelEnGBNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedTagRequestModelFrFR::class => \NoahVet\Reef\Cam\Normalizer\PetBreedTagRequestModelFrFRNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetBreedTagRequest::class => \NoahVet\Reef\Cam\Normalizer\PetBreedTagRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetBreedTagResponse::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetBreedTagResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetMicrochipRequest::class => \NoahVet\Reef\Cam\Normalizer\PetMicrochipRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetMicrochipResponse::class => \NoahVet\Reef\Cam\Normalizer\PetMicrochipResponseNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetProfileResponseItem::class => \NoahVet\Reef\Cam\Normalizer\PetProfileResponseItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetProfileRequest::class => \NoahVet\Reef\Cam\Normalizer\PetProfileRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest::class => \NoahVet\Reef\Cam\Normalizer\SchemasPetProfileRequestNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetSpecieResponseItem::class => \NoahVet\Reef\Cam\Normalizer\PetSpecieResponseItemNormalizer::class,
        
        \NoahVet\Reef\Cam\Model\PetSpecieResponseItemAliasesItem::class => \NoahVet\Reef\Cam\Normalizer\PetSpecieResponseItemAliasesItemNormalizer::class,
        
        \Jane\Component\JsonSchemaRuntime\Reference::class => \NoahVet\Reef\Cam\Runtime\Normalizer\ReferenceNormalizer::class,
    ], $normalizersCache = [];
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return array_key_exists($type, $this->normalizers);
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && array_key_exists(get_class($data), $this->normalizers);
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $normalizerClass = $this->normalizers[get_class($data)];
        $normalizer = $this->getNormalizer($normalizerClass);
        return $normalizer->normalize($data, $format, $context);
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        $denormalizerClass = $this->normalizers[$type];
        $denormalizer = $this->getNormalizer($denormalizerClass);
        return $denormalizer->denormalize($data, $type, $format, $context);
    }
    private function getNormalizer(string $normalizerClass)
    {
        return $this->normalizersCache[$normalizerClass] ?? $this->initNormalizer($normalizerClass);
    }
    private function initNormalizer(string $normalizerClass)
    {
        $normalizer = new $normalizerClass();
        $normalizer->setNormalizer($this->normalizer);
        $normalizer->setDenormalizer($this->denormalizer);
        $this->normalizersCache[$normalizerClass] = $normalizer;
        return $normalizer;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [
            
            \NoahVet\Reef\Cam\Model\NullableCompanyDetailResponse::class => false,
            \NoahVet\Reef\Cam\Model\IdResponse::class => false,
            \NoahVet\Reef\Cam\Model\NullableGeolocationResponse::class => false,
            \NoahVet\Reef\Cam\Model\ContactResponseItem::class => false,
            \NoahVet\Reef\Cam\Model\NullableCompanyDetailRequest::class => false,
            \NoahVet\Reef\Cam\Model\IdRequest::class => false,
            \NoahVet\Reef\Cam\Model\NullableGeolocationRequest::class => false,
            \NoahVet\Reef\Cam\Model\ContactRequest::class => false,
            \NoahVet\Reef\Cam\Model\SchemasContactResponse::class => false,
            \NoahVet\Reef\Cam\Model\SchemasContactRequest::class => false,
            \NoahVet\Reef\Cam\Model\CustomerResponseItem::class => false,
            \NoahVet\Reef\Cam\Model\CustomerRequest::class => false,
            \NoahVet\Reef\Cam\Model\SchemasCustomerResponse::class => false,
            \NoahVet\Reef\Cam\Model\NullableIdResponse::class => false,
            \NoahVet\Reef\Cam\Model\CustomerProfileResponseItem::class => false,
            \NoahVet\Reef\Cam\Model\CustomerProfileRequest::class => false,
            \NoahVet\Reef\Cam\Model\SchemasCustomerProfileResponse::class => false,
            \NoahVet\Reef\Cam\Model\NullableIdRequest::class => false,
            \NoahVet\Reef\Cam\Model\SchemasCustomerProfileRequest::class => false,
            \NoahVet\Reef\Cam\Model\PetResponseItem::class => false,
            \NoahVet\Reef\Cam\Model\PetResponseItemMicrochipsItem::class => false,
            \NoahVet\Reef\Cam\Model\PetResponseItemTattoo::class => false,
            \NoahVet\Reef\Cam\Model\PetRequest::class => false,
            \NoahVet\Reef\Cam\Model\PetRequestTattoo::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetResponse::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetResponseMicrochipsItem::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetResponseTattoo::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetRequest::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetRequestTattoo::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedResponseItem::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedResponseItemAliasesItem::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedRequestModel::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedRequestModelEnGB::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedRequestModelEnGBAliasesItem::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedRequestModelFrFR::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedRequestModelFrFRAliasesItem::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedRequest::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetBreedResponse::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetBreedResponseAliasesItem::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedExternalLinkResponseItem::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedExternalLinkRequest::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetBreedExternalLinkResponse::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedExternalRefResponseItem::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedExternalRefResponseItemCoveredLocales::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedExternalRefRequest::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedExternalRefRequestCoveredLocales::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetBreedExternalRefResponse::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetBreedExternalRefResponseCoveredLocales::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedLabellingResponseItem::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedLabellingRequest::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetBreedLabellingResponse::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedTagResponseItem::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedTagRequestModel::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedTagRequestModelEnGB::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedTagRequestModelFrFR::class => false,
            \NoahVet\Reef\Cam\Model\PetBreedTagRequest::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetBreedTagResponse::class => false,
            \NoahVet\Reef\Cam\Model\PetMicrochipRequest::class => false,
            \NoahVet\Reef\Cam\Model\PetMicrochipResponse::class => false,
            \NoahVet\Reef\Cam\Model\PetProfileResponseItem::class => false,
            \NoahVet\Reef\Cam\Model\PetProfileRequest::class => false,
            \NoahVet\Reef\Cam\Model\SchemasPetProfileRequest::class => false,
            \NoahVet\Reef\Cam\Model\PetSpecieResponseItem::class => false,
            \NoahVet\Reef\Cam\Model\PetSpecieResponseItemAliasesItem::class => false,
            \Jane\Component\JsonSchemaRuntime\Reference::class => false,
        ];
    }
}