<?php

namespace NoahVet\Reef\Bsm\Endpoint;

class GetAllPublisher extends \NoahVet\Reef\Bsm\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\Runtime\Client\Endpoint
{
    /**
    * List Publishers.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $legalStructureId[] Filter by legalStructureId.
    *     @var array $publisherUserId[] Filter by publisherUserId.
    *     @var array $code[] Filter by code.
    *     @var array $name[] Filter by name.
    *     @var array $type[] Filter by type.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCode Sort by code.
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortName Sort by name.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    */
    public function __construct(array $queryParameters = [], array $headerParameters = [])
    {
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Bsm\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return '/v1/publishers';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getQueryOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'limit', 'id', 'legalStructureId', 'publisherUserId', 'code', 'name', 'type', 'fromCreatedDate', 'fromUpdatedDate', 'toCreatedDate', 'toUpdatedDate', 'sortCode', 'sortCreatedDate', 'sortName', 'sortUpdatedDate']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('limit', ['int']);
        $optionsResolver->addAllowedTypes('id', ['array']);
        $optionsResolver->addAllowedTypes('legalStructureId', ['array']);
        $optionsResolver->addAllowedTypes('publisherUserId', ['array']);
        $optionsResolver->addAllowedTypes('code', ['array']);
        $optionsResolver->addAllowedTypes('name', ['array']);
        $optionsResolver->addAllowedTypes('type', ['array']);
        $optionsResolver->addAllowedTypes('fromCreatedDate', ['array']);
        $optionsResolver->addAllowedTypes('fromUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toCreatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('sortCode', ['string']);
        $optionsResolver->addAllowedTypes('sortCreatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortName', ['string']);
        $optionsResolver->addAllowedTypes('sortUpdatedDate', ['string']);
        return $optionsResolver;
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\Exception\GetAllPublisherBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\PublisherResponse[]
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\PublisherResponse[]', 'json');
        }
        if (is_null($contentType) === false && (206 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\PublisherResponse[]', 'json');
        }
        if (is_null($contentType) === false && (400 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Bsm\Exception\GetAllPublisherBadRequestException($response);
        }
        throw new \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}