<?php

namespace NoahVet\Reef\Bsm\Model;

class PublisherUserRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Publisher Department - Request Model
     *
     * @var list<string>
     */
    protected $departments;
    /**
     * 
     *
     * @var \DateTime
     */
    protected $entryDate;
    /**
     * 
     *
     * @var \DateTime|null
     */
    protected $exitDate;
    /**
     * Publisher JobTitle - Request Model
     *
     * @var string
     */
    protected $jobTitle;
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $user;
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $publisher;
    /**
     * Publisher Department - Request Model
     *
     * @return list<string>
     */
    public function getDepartments() : array
    {
        return $this->departments;
    }
    /**
     * Publisher Department - Request Model
     *
     * @param list<string> $departments
     *
     * @return self
     */
    public function setDepartments(array $departments) : self
    {
        $this->initialized['departments'] = true;
        $this->departments = $departments;
        return $this;
    }
    /**
     * 
     *
     * @return \DateTime
     */
    public function getEntryDate() : \DateTime
    {
        return $this->entryDate;
    }
    /**
     * 
     *
     * @param \DateTime $entryDate
     *
     * @return self
     */
    public function setEntryDate(\DateTime $entryDate) : self
    {
        $this->initialized['entryDate'] = true;
        $this->entryDate = $entryDate;
        return $this;
    }
    /**
     * 
     *
     * @return \DateTime|null
     */
    public function getExitDate() : ?\DateTime
    {
        return $this->exitDate;
    }
    /**
     * 
     *
     * @param \DateTime|null $exitDate
     *
     * @return self
     */
    public function setExitDate(?\DateTime $exitDate) : self
    {
        $this->initialized['exitDate'] = true;
        $this->exitDate = $exitDate;
        return $this;
    }
    /**
     * Publisher JobTitle - Request Model
     *
     * @return string
     */
    public function getJobTitle() : string
    {
        return $this->jobTitle;
    }
    /**
     * Publisher JobTitle - Request Model
     *
     * @param string $jobTitle
     *
     * @return self
     */
    public function setJobTitle(string $jobTitle) : self
    {
        $this->initialized['jobTitle'] = true;
        $this->jobTitle = $jobTitle;
        return $this;
    }
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getUser() : IdRequest
    {
        return $this->user;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $user
     *
     * @return self
     */
    public function setUser(IdRequest $user) : self
    {
        $this->initialized['user'] = true;
        $this->user = $user;
        return $this;
    }
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getPublisher() : IdRequest
    {
        return $this->publisher;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $publisher
     *
     * @return self
     */
    public function setPublisher(IdRequest $publisher) : self
    {
        $this->initialized['publisher'] = true;
        $this->publisher = $publisher;
        return $this;
    }
}