<?php

namespace NoahVet\Reef\Bsm\Model;

class VeterinaryGroupUserRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Veterinary Group Department - Request Model
     *
     * @var list<string>
     */
    protected $departments;
    /**
     * 
     *
     * @var \DateTime
     */
    protected $entryDate;
    /**
     * 
     *
     * @var \DateTime|null
     */
    protected $exitDate;
    /**
     * Veterinary Group JobTitle - Request Model
     *
     * @var string
     */
    protected $jobTitle;
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $user;
    /**
     * Id - Common Request Model
     *
     * @var IdRequest
     */
    protected $veterinaryGroup;
    /**
     * Veterinary Group Department - Request Model
     *
     * @return list<string>
     */
    public function getDepartments() : array
    {
        return $this->departments;
    }
    /**
     * Veterinary Group Department - Request Model
     *
     * @param list<string> $departments
     *
     * @return self
     */
    public function setDepartments(array $departments) : self
    {
        $this->initialized['departments'] = true;
        $this->departments = $departments;
        return $this;
    }
    /**
     * 
     *
     * @return \DateTime
     */
    public function getEntryDate() : \DateTime
    {
        return $this->entryDate;
    }
    /**
     * 
     *
     * @param \DateTime $entryDate
     *
     * @return self
     */
    public function setEntryDate(\DateTime $entryDate) : self
    {
        $this->initialized['entryDate'] = true;
        $this->entryDate = $entryDate;
        return $this;
    }
    /**
     * 
     *
     * @return \DateTime|null
     */
    public function getExitDate() : ?\DateTime
    {
        return $this->exitDate;
    }
    /**
     * 
     *
     * @param \DateTime|null $exitDate
     *
     * @return self
     */
    public function setExitDate(?\DateTime $exitDate) : self
    {
        $this->initialized['exitDate'] = true;
        $this->exitDate = $exitDate;
        return $this;
    }
    /**
     * Veterinary Group JobTitle - Request Model
     *
     * @return string
     */
    public function getJobTitle() : string
    {
        return $this->jobTitle;
    }
    /**
     * Veterinary Group JobTitle - Request Model
     *
     * @param string $jobTitle
     *
     * @return self
     */
    public function setJobTitle(string $jobTitle) : self
    {
        $this->initialized['jobTitle'] = true;
        $this->jobTitle = $jobTitle;
        return $this;
    }
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getUser() : IdRequest
    {
        return $this->user;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $user
     *
     * @return self
     */
    public function setUser(IdRequest $user) : self
    {
        $this->initialized['user'] = true;
        $this->user = $user;
        return $this;
    }
    /**
     * Id - Common Request Model
     *
     * @return IdRequest
     */
    public function getVeterinaryGroup() : IdRequest
    {
        return $this->veterinaryGroup;
    }
    /**
     * Id - Common Request Model
     *
     * @param IdRequest $veterinaryGroup
     *
     * @return self
     */
    public function setVeterinaryGroup(IdRequest $veterinaryGroup) : self
    {
        $this->initialized['veterinaryGroup'] = true;
        $this->veterinaryGroup = $veterinaryGroup;
        return $this;
    }
}