<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class PublisherRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\PublisherRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\PublisherRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\PublisherRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('banner', $data) && $data['banner'] !== null) {
            $object->setBanner($this->denormalizer->denormalize($data['banner'], \NoahVet\Reef\Bsm\Model\NullableIdRequest::class, 'json', $context));
            unset($data['banner']);
        }
        elseif (\array_key_exists('banner', $data) && $data['banner'] === null) {
            $object->setBanner(null);
        }
        if (\array_key_exists('code', $data)) {
            $object->setCode($data['code']);
            unset($data['code']);
        }
        if (\array_key_exists('customName', $data) && $data['customName'] !== null) {
            $object->setCustomName($data['customName']);
            unset($data['customName']);
        }
        elseif (\array_key_exists('customName', $data) && $data['customName'] === null) {
            $object->setCustomName(null);
        }
        if (\array_key_exists('legalStructure', $data)) {
            $object->setLegalStructure($this->denormalizer->denormalize($data['legalStructure'], \NoahVet\Reef\Bsm\Model\IdRequest::class, 'json', $context));
            unset($data['legalStructure']);
        }
        if (\array_key_exists('logo', $data) && $data['logo'] !== null) {
            $object->setLogo($this->denormalizer->denormalize($data['logo'], \NoahVet\Reef\Bsm\Model\NullableIdRequest::class, 'json', $context));
            unset($data['logo']);
        }
        elseif (\array_key_exists('logo', $data) && $data['logo'] === null) {
            $object->setLogo(null);
        }
        if (\array_key_exists('longDescription', $data) && $data['longDescription'] !== null) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        }
        elseif (\array_key_exists('longDescription', $data) && $data['longDescription'] === null) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('mainBillingAccount', $data) && $data['mainBillingAccount'] !== null) {
            $object->setMainBillingAccount($this->denormalizer->denormalize($data['mainBillingAccount'], \NoahVet\Reef\Bsm\Model\NullableIdRequest::class, 'json', $context));
            unset($data['mainBillingAccount']);
        }
        elseif (\array_key_exists('mainBillingAccount', $data) && $data['mainBillingAccount'] === null) {
            $object->setMainBillingAccount(null);
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('serviceVatCategory', $data)) {
            $object->setServiceVatCategory($data['serviceVatCategory']);
            unset($data['serviceVatCategory']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('banner') && null !== $data->getBanner()) {
            $dataArray['banner'] = $this->normalizer->normalize($data->getBanner(), 'json', $context);
        }
        $dataArray['code'] = $data->getCode();
        $dataArray['customName'] = $data->getCustomName();
        $dataArray['legalStructure'] = $this->normalizer->normalize($data->getLegalStructure(), 'json', $context);
        if ($data->isInitialized('logo') && null !== $data->getLogo()) {
            $dataArray['logo'] = $this->normalizer->normalize($data->getLogo(), 'json', $context);
        }
        $dataArray['longDescription'] = $data->getLongDescription();
        if ($data->isInitialized('mainBillingAccount') && null !== $data->getMainBillingAccount()) {
            $dataArray['mainBillingAccount'] = $this->normalizer->normalize($data->getMainBillingAccount(), 'json', $context);
        }
        $dataArray['name'] = $data->getName();
        $dataArray['serviceVatCategory'] = $data->getServiceVatCategory();
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\PublisherRequest::class => false];
    }
}