<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentCreditNoteBulkRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteBulkRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteBulkRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteBulkRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingStatus', $data) && $data['accountingStatus'] !== null) {
            $object->setAccountingStatus($data['accountingStatus']);
            unset($data['accountingStatus']);
        }
        elseif (\array_key_exists('accountingStatus', $data) && $data['accountingStatus'] === null) {
            $object->setAccountingStatus(null);
        }
        if (\array_key_exists('resources', $data)) {
            $values = [];
            foreach ($data['resources'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Bsm\Model\IdRequest::class, 'json', $context);
            }
            $object->setResources($values);
            unset($data['resources']);
        }
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('accountingStatus') && null !== $data->getAccountingStatus()) {
            $dataArray['accountingStatus'] = $data->getAccountingStatus();
        }
        $values = [];
        foreach ($data->getResources() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $dataArray['resources'] = $values;
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentCreditNoteBulkRequest::class => false];
    }
}