<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('banner', $data) && $data['banner'] !== null) {
            $object->setBanner($this->denormalizer->denormalize($data['banner'], \NoahVet\Reef\Bsm\Model\NullableIdRequest::class, 'json', $context));
            unset($data['banner']);
        }
        elseif (\array_key_exists('banner', $data) && $data['banner'] === null) {
            $object->setBanner(null);
        }
        if (\array_key_exists('customName', $data) && $data['customName'] !== null) {
            $object->setCustomName($data['customName']);
            unset($data['customName']);
        }
        elseif (\array_key_exists('customName', $data) && $data['customName'] === null) {
            $object->setCustomName(null);
        }
        if (\array_key_exists('entryNumber', $data) && $data['entryNumber'] !== null) {
            $object->setEntryNumber($data['entryNumber']);
            unset($data['entryNumber']);
        }
        elseif (\array_key_exists('entryNumber', $data) && $data['entryNumber'] === null) {
            $object->setEntryNumber(null);
        }
        if (\array_key_exists('internalCommentary', $data) && $data['internalCommentary'] !== null) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        }
        elseif (\array_key_exists('internalCommentary', $data) && $data['internalCommentary'] === null) {
            $object->setInternalCommentary(null);
        }
        if (\array_key_exists('legalStructure', $data)) {
            $object->setLegalStructure($this->denormalizer->denormalize($data['legalStructure'], \NoahVet\Reef\Bsm\Model\IdRequest::class, 'json', $context));
            unset($data['legalStructure']);
        }
        if (\array_key_exists('logo', $data) && $data['logo'] !== null) {
            $object->setLogo($this->denormalizer->denormalize($data['logo'], \NoahVet\Reef\Bsm\Model\NullableIdRequest::class, 'json', $context));
            unset($data['logo']);
        }
        elseif (\array_key_exists('logo', $data) && $data['logo'] === null) {
            $object->setLogo(null);
        }
        if (\array_key_exists('longDescription', $data) && $data['longDescription'] !== null) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        }
        elseif (\array_key_exists('longDescription', $data) && $data['longDescription'] === null) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('mainBillingAccount', $data) && $data['mainBillingAccount'] !== null) {
            $object->setMainBillingAccount($this->denormalizer->denormalize($data['mainBillingAccount'], \NoahVet\Reef\Bsm\Model\NullableIdRequest::class, 'json', $context));
            unset($data['mainBillingAccount']);
        }
        elseif (\array_key_exists('mainBillingAccount', $data) && $data['mainBillingAccount'] === null) {
            $object->setMainBillingAccount(null);
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('personalisedMention', $data) && $data['personalisedMention'] !== null) {
            $object->setPersonalisedMention($data['personalisedMention']);
            unset($data['personalisedMention']);
        }
        elseif (\array_key_exists('personalisedMention', $data) && $data['personalisedMention'] === null) {
            $object->setPersonalisedMention(null);
        }
        if (\array_key_exists('pictures', $data) && $data['pictures'] !== null) {
            $values = [];
            foreach ($data['pictures'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Bsm\Model\IdRequest::class, 'json', $context);
            }
            $object->setPictures($values);
            unset($data['pictures']);
        }
        elseif (\array_key_exists('pictures', $data) && $data['pictures'] === null) {
            $object->setPictures(null);
        }
        if (\array_key_exists('privilegedCode', $data)) {
            $object->setPrivilegedCode($data['privilegedCode']);
            unset($data['privilegedCode']);
        }
        if (\array_key_exists('schedule', $data)) {
            $object->setSchedule($this->denormalizer->denormalize($data['schedule'], \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequestSchedule::class, 'json', $context));
            unset($data['schedule']);
        }
        if (\array_key_exists('serviceVatCategory', $data)) {
            $object->setServiceVatCategory($data['serviceVatCategory']);
            unset($data['serviceVatCategory']);
        }
        if (\array_key_exists('shortDescription', $data) && $data['shortDescription'] !== null) {
            $object->setShortDescription($data['shortDescription']);
            unset($data['shortDescription']);
        }
        elseif (\array_key_exists('shortDescription', $data) && $data['shortDescription'] === null) {
            $object->setShortDescription(null);
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('banner') && null !== $data->getBanner()) {
            $dataArray['banner'] = $this->normalizer->normalize($data->getBanner(), 'json', $context);
        }
        if ($data->isInitialized('customName') && null !== $data->getCustomName()) {
            $dataArray['customName'] = $data->getCustomName();
        }
        if ($data->isInitialized('entryNumber') && null !== $data->getEntryNumber()) {
            $dataArray['entryNumber'] = $data->getEntryNumber();
        }
        if ($data->isInitialized('internalCommentary') && null !== $data->getInternalCommentary()) {
            $dataArray['internalCommentary'] = $data->getInternalCommentary();
        }
        $dataArray['legalStructure'] = $this->normalizer->normalize($data->getLegalStructure(), 'json', $context);
        if ($data->isInitialized('logo') && null !== $data->getLogo()) {
            $dataArray['logo'] = $this->normalizer->normalize($data->getLogo(), 'json', $context);
        }
        if ($data->isInitialized('longDescription') && null !== $data->getLongDescription()) {
            $dataArray['longDescription'] = $data->getLongDescription();
        }
        if ($data->isInitialized('mainBillingAccount') && null !== $data->getMainBillingAccount()) {
            $dataArray['mainBillingAccount'] = $this->normalizer->normalize($data->getMainBillingAccount(), 'json', $context);
        }
        $dataArray['name'] = $data->getName();
        $dataArray['personalisedMention'] = $data->getPersonalisedMention();
        if ($data->isInitialized('pictures') && null !== $data->getPictures()) {
            $values = [];
            foreach ($data->getPictures() as $value) {
                $values[] = $this->normalizer->normalize($value, 'json', $context);
            }
            $dataArray['pictures'] = $values;
        }
        $dataArray['privilegedCode'] = $data->getPrivilegedCode();
        $dataArray['schedule'] = $this->normalizer->normalize($data->getSchedule(), 'json', $context);
        $dataArray['serviceVatCategory'] = $data->getServiceVatCategory();
        if ($data->isInitialized('shortDescription') && null !== $data->getShortDescription()) {
            $dataArray['shortDescription'] = $data->getShortDescription();
        }
        $dataArray['type'] = $data->getType();
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentRequest::class => false];
    }
}