<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class SchemasBillingAccountRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\SchemasBillingAccountRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\SchemasBillingAccountRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\SchemasBillingAccountRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('bicSwift', $data) && $data['bicSwift'] !== null) {
            $object->setBicSwift($data['bicSwift']);
            unset($data['bicSwift']);
        }
        elseif (\array_key_exists('bicSwift', $data) && $data['bicSwift'] === null) {
            $object->setBicSwift(null);
        }
        if (\array_key_exists('entitled', $data) && $data['entitled'] !== null) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        elseif (\array_key_exists('entitled', $data) && $data['entitled'] === null) {
            $object->setEntitled(null);
        }
        if (\array_key_exists('file', $data) && $data['file'] !== null) {
            $object->setFile($this->denormalizer->denormalize($data['file'], \NoahVet\Reef\Bsm\Model\NullableIdRequest::class, 'json', $context));
            unset($data['file']);
        }
        elseif (\array_key_exists('file', $data) && $data['file'] === null) {
            $object->setFile(null);
        }
        if (\array_key_exists('iban', $data) && $data['iban'] !== null) {
            $object->setIban($data['iban']);
            unset($data['iban']);
        }
        elseif (\array_key_exists('iban', $data) && $data['iban'] === null) {
            $object->setIban(null);
        }
        if (\array_key_exists('identityName', $data) && $data['identityName'] !== null) {
            $object->setIdentityName($data['identityName']);
            unset($data['identityName']);
        }
        elseif (\array_key_exists('identityName', $data) && $data['identityName'] === null) {
            $object->setIdentityName(null);
        }
        if (\array_key_exists('status', $data) && $data['status'] !== null) {
            $object->setStatus($data['status']);
            unset($data['status']);
        }
        elseif (\array_key_exists('status', $data) && $data['status'] === null) {
            $object->setStatus(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('bicSwift') && null !== $data->getBicSwift()) {
            $dataArray['bicSwift'] = $data->getBicSwift();
        }
        if ($data->isInitialized('entitled') && null !== $data->getEntitled()) {
            $dataArray['entitled'] = $data->getEntitled();
        }
        if ($data->isInitialized('file') && null !== $data->getFile()) {
            $dataArray['file'] = $this->normalizer->normalize($data->getFile(), 'json', $context);
        }
        if ($data->isInitialized('iban') && null !== $data->getIban()) {
            $dataArray['iban'] = $data->getIban();
        }
        if ($data->isInitialized('identityName') && null !== $data->getIdentityName()) {
            $dataArray['identityName'] = $data->getIdentityName();
        }
        if ($data->isInitialized('status') && null !== $data->getStatus()) {
            $dataArray['status'] = $data->getStatus();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\SchemasBillingAccountRequest::class => false];
    }
}