<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class ManufacturerUserResponseItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItem::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItem::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('departments', $data)) {
            $values = [];
            foreach ($data['departments'] as $value) {
                $values[] = $value;
            }
            $object->setDepartments($values);
            unset($data['departments']);
        }
        if (\array_key_exists('entryDate', $data)) {
            $object->setEntryDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['entryDate']));
            unset($data['entryDate']);
        }
        if (\array_key_exists('exitDate', $data) && $data['exitDate'] !== null) {
            $object->setExitDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['exitDate']));
            unset($data['exitDate']);
        }
        elseif (\array_key_exists('exitDate', $data) && $data['exitDate'] === null) {
            $object->setExitDate(null);
        }
        if (\array_key_exists('jobTitle', $data)) {
            $object->setJobTitle($data['jobTitle']);
            unset($data['jobTitle']);
        }
        if (\array_key_exists('manufacturer', $data) && $data['manufacturer'] !== null) {
            $object->setManufacturer($this->denormalizer->denormalize($data['manufacturer'], \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItemManufacturer::class, 'json', $context));
            unset($data['manufacturer']);
        }
        elseif (\array_key_exists('manufacturer', $data) && $data['manufacturer'] === null) {
            $object->setManufacturer(null);
        }
        if (\array_key_exists('user', $data) && $data['user'] !== null) {
            $object->setUser($this->denormalizer->denormalize($data['user'], \NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItemUser::class, 'json', $context));
            unset($data['user']);
        }
        elseif (\array_key_exists('user', $data) && $data['user'] === null) {
            $object->setUser(null);
        }
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('id') && null !== $data->getId()) {
            $dataArray['id'] = $data->getId();
        }
        if ($data->isInitialized('createdDate') && null !== $data->getCreatedDate()) {
            $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('updatedDate') && null !== $data->getUpdatedDate()) {
            $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('departments') && null !== $data->getDepartments()) {
            $values = [];
            foreach ($data->getDepartments() as $value) {
                $values[] = $value;
            }
            $dataArray['departments'] = $values;
        }
        if ($data->isInitialized('entryDate') && null !== $data->getEntryDate()) {
            $dataArray['entryDate'] = $data->getEntryDate()?->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('exitDate') && null !== $data->getExitDate()) {
            $dataArray['exitDate'] = $data->getExitDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('jobTitle') && null !== $data->getJobTitle()) {
            $dataArray['jobTitle'] = $data->getJobTitle();
        }
        if ($data->isInitialized('manufacturer') && null !== $data->getManufacturer()) {
            $dataArray['manufacturer'] = $this->normalizer->normalize($data->getManufacturer(), 'json', $context);
        }
        if ($data->isInitialized('user') && null !== $data->getUser()) {
            $dataArray['user'] = $this->normalizer->normalize($data->getUser(), 'json', $context);
        }
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\ManufacturerUserResponseItem::class => false];
    }
}