<?php

namespace NoahVet\Reef\Bsm\Endpoint;

class GetAllInvoice extends \NoahVet\Reef\Bsm\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\Runtime\Client\Endpoint
{
    /**
    * List Invoices.
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $veterinaryEstablishmentServiceDeliveryId[] Filter by veterinaryEstablishmentServiceDeliveryId.
    *     @var array $veterinaryEstablishmentServicePeriodId[] Filter by veterinaryEstablishmentServicePeriodId.
    *     @var array $category[] Filter by invoice category.
    *     @var array $paymentMethod[] Filter by paymentMethod.
    *     @var array $paymentStatus[] Filter by paymentStatus.
    *     @var array $accountingCode[] Filter by accountingCode.
    *     @var array $accountingMovementIncrementalNumber[] Filter by accountingMovementIncrementalNumber.
    *     @var array $bankAccountRum[] Filter by bankAccountRum.
    *     @var array $deliveryInformationCode[] Filter by deliveryInformationCode.
    *     @var array $senderAddressIdentityName[] Filter by sender identityName.
    *     @var array $fromAccountingMovementIncrementalNumber[] Returns results whose `incrementalNumber of accountingMovement` is greater than or equal to the specified value.
    Example for FAC-V000002 value :
    
    |  FAC-V000001 |  FAC-V000002  FAC-V000003  |
    |----Filtered--|----------Returned----------|
    
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toAccountingMovementIncrementalNumber[] Returns results whose `incrementalNumber of accountingMovement` is lower than or equal to the specified value.
    Example for FAC-V000002 value :
    
    |  FAC-V000001  FAC-V000002 |  FAC-V000003 |
    |----------Returned---------|---Filtered---|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortAccountingMovementIncrementalNumber Sort by incrementalNumber of accountingMovement.
    *     @var string $sortAmountWithoutVat Sort by amountWithoutVat.
    *     @var string $sortAmountWithVat Sort by amountWithVat.
    *     @var string $sortBankAccountRum Sort by BankAccountRum.
    *     @var string $sortCategory Sort by category.
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortDeliveryInformationCode Sort by deliveryInformationCode.
    *     @var string $sortPaymentMethod Sort by paymentStatus.
    *     @var string $sortPaymentStatus Sort by paymentStatus.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    */
    public function __construct(array $queryParameters = [], array $headerParameters = [])
    {
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Bsm\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return '/v1/invoices';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getQueryOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'limit', 'id', 'veterinaryEstablishmentServiceDeliveryId', 'veterinaryEstablishmentServicePeriodId', 'category', 'paymentMethod', 'paymentStatus', 'accountingCode', 'accountingMovementIncrementalNumber', 'bankAccountRum', 'deliveryInformationCode', 'senderAddressIdentityName', 'fromAccountingMovementIncrementalNumber', 'fromCreatedDate', 'fromUpdatedDate', 'toAccountingMovementIncrementalNumber', 'toCreatedDate', 'toUpdatedDate', 'sortAccountingMovementIncrementalNumber', 'sortAmountWithoutVat', 'sortAmountWithVat', 'sortBankAccountRum', 'sortCategory', 'sortCreatedDate', 'sortDeliveryInformationCode', 'sortPaymentMethod', 'sortPaymentStatus', 'sortUpdatedDate']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('limit', ['int']);
        $optionsResolver->addAllowedTypes('id', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentServiceDeliveryId', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentServicePeriodId', ['array']);
        $optionsResolver->addAllowedTypes('category', ['array']);
        $optionsResolver->addAllowedTypes('paymentMethod', ['array']);
        $optionsResolver->addAllowedTypes('paymentStatus', ['array']);
        $optionsResolver->addAllowedTypes('accountingCode', ['array']);
        $optionsResolver->addAllowedTypes('accountingMovementIncrementalNumber', ['array']);
        $optionsResolver->addAllowedTypes('bankAccountRum', ['array']);
        $optionsResolver->addAllowedTypes('deliveryInformationCode', ['array']);
        $optionsResolver->addAllowedTypes('senderAddressIdentityName', ['array']);
        $optionsResolver->addAllowedTypes('fromAccountingMovementIncrementalNumber', ['array', 'null']);
        $optionsResolver->addAllowedTypes('fromCreatedDate', ['array']);
        $optionsResolver->addAllowedTypes('fromUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toAccountingMovementIncrementalNumber', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toCreatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('sortAccountingMovementIncrementalNumber', ['string']);
        $optionsResolver->addAllowedTypes('sortAmountWithoutVat', ['string']);
        $optionsResolver->addAllowedTypes('sortAmountWithVat', ['string']);
        $optionsResolver->addAllowedTypes('sortBankAccountRum', ['string']);
        $optionsResolver->addAllowedTypes('sortCategory', ['string']);
        $optionsResolver->addAllowedTypes('sortCreatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortDeliveryInformationCode', ['string']);
        $optionsResolver->addAllowedTypes('sortPaymentMethod', ['string']);
        $optionsResolver->addAllowedTypes('sortPaymentStatus', ['string']);
        $optionsResolver->addAllowedTypes('sortUpdatedDate', ['string']);
        return $optionsResolver;
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\Exception\GetAllInvoiceBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\InvoiceResponse[]
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\InvoiceResponse[]', 'json');
        }
        if (is_null($contentType) === false && (206 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\InvoiceResponse[]', 'json');
        }
        if (is_null($contentType) === false && (400 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Bsm\Exception\GetAllInvoiceBadRequestException($response);
        }
        throw new \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}