<?php

namespace NoahVet\Reef\Bsm\Endpoint;

class GetTmpVeterinaryEstablishmentInvoice extends \NoahVet\Reef\Bsm\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\Runtime\Client\Endpoint
{
    protected $a;
    /**
     * Get Tmp Veterinary Establishment Invoice.
     *
     * @param string $a The dynamic name.
     */
    public function __construct(string $a)
    {
        $this->a = $a;
    }
    use \NoahVet\Reef\Bsm\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return str_replace(['{a}'], [$this->a], '/tmp/veterinary_establishment_invoices/{a}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentInvoiceBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentInvoiceNotFoundException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (200 === $status) {
            return null;
        }
        if (is_null($contentType) === false && (400 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentInvoiceBadRequestException($response);
        }
        if (is_null($contentType) === false && (404 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Bsm\Exception\GetTmpVeterinaryEstablishmentInvoiceNotFoundException($response);
        }
        throw new \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}