<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentMemberResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('accountingCode', $data) && $data['accountingCode'] !== null) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        }
        elseif (\array_key_exists('accountingCode', $data) && $data['accountingCode'] === null) {
            $object->setAccountingCode(null);
        }
        if (\array_key_exists('entryDate', $data)) {
            $object->setEntryDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['entryDate']));
            unset($data['entryDate']);
        }
        if (\array_key_exists('exitDate', $data) && $data['exitDate'] !== null) {
            $object->setExitDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['exitDate']));
            unset($data['exitDate']);
        }
        elseif (\array_key_exists('exitDate', $data) && $data['exitDate'] === null) {
            $object->setExitDate(null);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], \NoahVet\Reef\Bsm\Model\IdResponse::class, 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        if (\array_key_exists('veterinaryGroup', $data)) {
            $object->setVeterinaryGroup($this->denormalizer->denormalize($data['veterinaryGroup'], \NoahVet\Reef\Bsm\Model\IdResponse::class, 'json', $context));
            unset($data['veterinaryGroup']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['accountingCode'] = $data->getAccountingCode();
        if ($data->isInitialized('entryDate') && null !== $data->getEntryDate()) {
            $dataArray['entryDate'] = $data->getEntryDate()?->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('exitDate') && null !== $data->getExitDate()) {
            $dataArray['exitDate'] = $data->getExitDate()->format('Y-m-d\\TH:i:sP');
        }
        $dataArray['veterinaryEstablishment'] = $this->normalizer->normalize($data->getVeterinaryEstablishment(), 'json', $context);
        $dataArray['veterinaryGroup'] = $this->normalizer->normalize($data->getVeterinaryGroup(), 'json', $context);
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentMemberResponse::class => false];
    }
}