<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryGroupUserInvitationConfirmationResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationConfirmationResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationConfirmationResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationConfirmationResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('status', $data)) {
            $object->setStatus($data['status']);
            unset($data['status']);
        }
        if (\array_key_exists('veterinaryGroupUserInvitation', $data) && $data['veterinaryGroupUserInvitation'] !== null) {
            $object->setVeterinaryGroupUserInvitation($this->denormalizer->denormalize($data['veterinaryGroupUserInvitation'], \NoahVet\Reef\Bsm\Model\NullableIdResponse::class, 'json', $context));
            unset($data['veterinaryGroupUserInvitation']);
        }
        elseif (\array_key_exists('veterinaryGroupUserInvitation', $data) && $data['veterinaryGroupUserInvitation'] === null) {
            $object->setVeterinaryGroupUserInvitation(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['status'] = $data->getStatus();
        $dataArray['veterinaryGroupUserInvitation'] = $this->normalizer->normalize($data->getVeterinaryGroupUserInvitation(), 'json', $context);
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\VeterinaryGroupUserInvitationConfirmationResponse::class => false];
    }
}