<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class ComponentsSchemasLegalStructureResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\ComponentsSchemasLegalStructureResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\ComponentsSchemasLegalStructureResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\ComponentsSchemasLegalStructureResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('apeCode', $data) && $data['apeCode'] !== null) {
            $object->setApeCode($data['apeCode']);
            unset($data['apeCode']);
        }
        elseif (\array_key_exists('apeCode', $data) && $data['apeCode'] === null) {
            $object->setApeCode(null);
        }
        if (\array_key_exists('headQuarterAddress', $data) && $data['headQuarterAddress'] !== null) {
            $object->setHeadQuarterAddress($this->denormalizer->denormalize($data['headQuarterAddress'], \NoahVet\Reef\Bsm\Model\PostalAddressResponse::class, 'json', $context));
            unset($data['headQuarterAddress']);
        }
        elseif (\array_key_exists('headQuarterAddress', $data) && $data['headQuarterAddress'] === null) {
            $object->setHeadQuarterAddress(null);
        }
        if (\array_key_exists('legalCode', $data)) {
            $object->setLegalCode($data['legalCode']);
            unset($data['legalCode']);
        }
        if (\array_key_exists('legalForm', $data)) {
            $object->setLegalForm($data['legalForm']);
            unset($data['legalForm']);
        }
        if (\array_key_exists('socialReason', $data)) {
            $object->setSocialReason($data['socialReason']);
            unset($data['socialReason']);
        }
        if (\array_key_exists('tradeName', $data) && $data['tradeName'] !== null) {
            $object->setTradeName($data['tradeName']);
            unset($data['tradeName']);
        }
        elseif (\array_key_exists('tradeName', $data) && $data['tradeName'] === null) {
            $object->setTradeName(null);
        }
        if (\array_key_exists('vatIntraCommunityNumber', $data) && $data['vatIntraCommunityNumber'] !== null) {
            $object->setVatIntraCommunityNumber($data['vatIntraCommunityNumber']);
            unset($data['vatIntraCommunityNumber']);
        }
        elseif (\array_key_exists('vatIntraCommunityNumber', $data) && $data['vatIntraCommunityNumber'] === null) {
            $object->setVatIntraCommunityNumber(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['apeCode'] = $data->getApeCode();
        $dataArray['headQuarterAddress'] = $this->normalizer->normalize($data->getHeadQuarterAddress(), 'json', $context);
        $dataArray['legalCode'] = $data->getLegalCode();
        $dataArray['legalForm'] = $data->getLegalForm();
        $dataArray['socialReason'] = $data->getSocialReason();
        $dataArray['tradeName'] = $data->getTradeName();
        $dataArray['vatIntraCommunityNumber'] = $data->getVatIntraCommunityNumber();
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\ComponentsSchemasLegalStructureResponse::class => false];
    }
}