<?php

namespace NoahVet\Reef\Bsm\Endpoint;

class SearchVeterinaryEstablishment extends \NoahVet\Reef\Bsm\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Bsm\Runtime\Client\Endpoint
{
    /**
    * Search on Veterinary Establishments.
    A veterinary establishment is a company, enterprise, association identifiable by a legalCode.
    
    *
    * @param \NoahVet\Reef\Bsm\Model\SearchRequest $requestBody 
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $id[] Filter by id.
    *     @var array $legalStructureId[] Filter by legalStructureId.
    *     @var array $veuUserId[] Filter by userId of Veterinary Establishment User.
    *     @var array $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId.
    *     @var array $name[] Filter by name.
    *     @var array $privilegedCode[] Filter by privilegedCode.
    *     @var array $type[] Filter by type.
    *     @var array $veterinaryEstablishmentTag[] Filter by veterinaryEstablishmentTag.
    *     @var array $veterinaryEstablishmentServicePeriodDate[] Returns results whose `veterinaryEstablishmentServicePeriodDate` is equal to the specified value.
    Example for 2022-03-15 value :
    
        2021                              2022
    |----Dec----||----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |--Filtered--|-------------------------Returned------------------------|
    
    *     @var array $veterinaryServiceOptionCode[] 
    *     @var array $veuJobTitle[] Filter by jobTitle of veterinary establishment user.
    *     @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreatedDate Sort by createdDate.
    *     @var string $sortEntryNumber Sort by entryNumber.
    *     @var string $sortName Sort by name.
    *     @var string $sortPrivilegedCode Sort by privilegedCode.
    *     @var string $sortType Sort by type.
    *     @var string $sortUpdatedDate Sort by updatedDate.
    *     @var string $sortVeterinaryEstablishmentAddressPostalCode Sort by postalCode of veterinaryEstablishmentAddress.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    */
    public function __construct(\NoahVet\Reef\Bsm\Model\SearchRequest $requestBody, array $queryParameters = [], array $headerParameters = [])
    {
        $this->body = $requestBody;
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\Reef\Bsm\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'POST';
    }
    public function getUri() : string
    {
        return '/v1/veterinary_establishments/search';
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\Reef\Bsm\Model\SearchRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getQueryOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'limit', 'id', 'legalStructureId', 'veuUserId', 'veterinaryEstablishmentMemberId', 'name', 'privilegedCode', 'type', 'veterinaryEstablishmentTag', 'veterinaryEstablishmentServicePeriodDate', 'veterinaryServiceOptionCode', 'veuJobTitle', 'fromCreatedDate', 'fromUpdatedDate', 'toCreatedDate', 'toUpdatedDate', 'sortCreatedDate', 'sortEntryNumber', 'sortName', 'sortPrivilegedCode', 'sortType', 'sortUpdatedDate', 'sortVeterinaryEstablishmentAddressPostalCode']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('limit', ['int']);
        $optionsResolver->addAllowedTypes('id', ['array']);
        $optionsResolver->addAllowedTypes('legalStructureId', ['array']);
        $optionsResolver->addAllowedTypes('veuUserId', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentMemberId', ['array']);
        $optionsResolver->addAllowedTypes('name', ['array']);
        $optionsResolver->addAllowedTypes('privilegedCode', ['array']);
        $optionsResolver->addAllowedTypes('type', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentTag', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentServicePeriodDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('veterinaryServiceOptionCode', ['array']);
        $optionsResolver->addAllowedTypes('veuJobTitle', ['array']);
        $optionsResolver->addAllowedTypes('fromCreatedDate', ['array']);
        $optionsResolver->addAllowedTypes('fromUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toCreatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('sortCreatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortEntryNumber', ['string']);
        $optionsResolver->addAllowedTypes('sortName', ['string']);
        $optionsResolver->addAllowedTypes('sortPrivilegedCode', ['string']);
        $optionsResolver->addAllowedTypes('sortType', ['string']);
        $optionsResolver->addAllowedTypes('sortUpdatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortVeterinaryEstablishmentAddressPostalCode', ['string']);
        return $optionsResolver;
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\Reef\Bsm\Exception\SearchVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentResponse[]
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\VeterinaryEstablishmentResponse[]', 'json');
        }
        if (is_null($contentType) === false && (206 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Bsm\\Model\\VeterinaryEstablishmentResponse[]', 'json');
        }
        if (is_null($contentType) === false && (400 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            throw new \NoahVet\Reef\Bsm\Exception\SearchVeterinaryEstablishmentBadRequestException($response);
        }
        throw new \NoahVet\Reef\Bsm\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}