<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentServiceDeliveryResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryResponse();
        if (\array_key_exists('shouldGenerateInvoice', $data) && \is_int($data['shouldGenerateInvoice'])) {
            $data['shouldGenerateInvoice'] = (bool) $data['shouldGenerateInvoice'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('accountingCode', $data)) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        }
        if (\array_key_exists('completionDate', $data) && $data['completionDate'] !== null) {
            $object->setCompletionDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['completionDate']));
            unset($data['completionDate']);
        }
        elseif (\array_key_exists('completionDate', $data) && $data['completionDate'] === null) {
            $object->setCompletionDate(null);
        }
        if (\array_key_exists('internalCommentary', $data) && $data['internalCommentary'] !== null) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        }
        elseif (\array_key_exists('internalCommentary', $data) && $data['internalCommentary'] === null) {
            $object->setInternalCommentary(null);
        }
        if (\array_key_exists('invoiceDate', $data) && $data['invoiceDate'] !== null) {
            $object->setInvoiceDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['invoiceDate']));
            unset($data['invoiceDate']);
        }
        elseif (\array_key_exists('invoiceDate', $data) && $data['invoiceDate'] === null) {
            $object->setInvoiceDate(null);
        }
        if (\array_key_exists('longDescription', $data) && $data['longDescription'] !== null) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        }
        elseif (\array_key_exists('longDescription', $data) && $data['longDescription'] === null) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('paymentMethod', $data)) {
            $object->setPaymentMethod($data['paymentMethod']);
            unset($data['paymentMethod']);
        }
        if (\array_key_exists('serviceDeliveryOption', $data)) {
            $object->setServiceDeliveryOption($this->denormalizer->denormalize($data['serviceDeliveryOption'], \NoahVet\Reef\Bsm\Model\IdResponse::class, 'json', $context));
            unset($data['serviceDeliveryOption']);
        }
        if (\array_key_exists('shouldGenerateInvoice', $data)) {
            $object->setShouldGenerateInvoice($data['shouldGenerateInvoice']);
            unset($data['shouldGenerateInvoice']);
        }
        if (\array_key_exists('specificBillingAccount', $data) && $data['specificBillingAccount'] !== null) {
            $object->setSpecificBillingAccount($this->denormalizer->denormalize($data['specificBillingAccount'], \NoahVet\Reef\Bsm\Model\NullableIdResponse::class, 'json', $context));
            unset($data['specificBillingAccount']);
        }
        elseif (\array_key_exists('specificBillingAccount', $data) && $data['specificBillingAccount'] === null) {
            $object->setSpecificBillingAccount(null);
        }
        if (\array_key_exists('specificVeterinaryGroup', $data) && $data['specificVeterinaryGroup'] !== null) {
            $object->setSpecificVeterinaryGroup($this->denormalizer->denormalize($data['specificVeterinaryGroup'], \NoahVet\Reef\Bsm\Model\NullableIdResponse::class, 'json', $context));
            unset($data['specificVeterinaryGroup']);
        }
        elseif (\array_key_exists('specificVeterinaryGroup', $data) && $data['specificVeterinaryGroup'] === null) {
            $object->setSpecificVeterinaryGroup(null);
        }
        if (\array_key_exists('unitPriceWithoutVat', $data)) {
            $object->setUnitPriceWithoutVat($data['unitPriceWithoutVat']);
            unset($data['unitPriceWithoutVat']);
        }
        if (\array_key_exists('unitPriceWithVat', $data)) {
            $object->setUnitPriceWithVat($data['unitPriceWithVat']);
            unset($data['unitPriceWithVat']);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], \NoahVet\Reef\Bsm\Model\IdResponse::class, 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['accountingCode'] = $data->getAccountingCode();
        $dataArray['completionDate'] = $data->getCompletionDate()->format('Y-m-d\\TH:i:sP');
        $dataArray['internalCommentary'] = $data->getInternalCommentary();
        $dataArray['invoiceDate'] = $data->getInvoiceDate()->format('Y-m-d\\TH:i:sP');
        $dataArray['longDescription'] = $data->getLongDescription();
        $dataArray['paymentMethod'] = $data->getPaymentMethod();
        $dataArray['serviceDeliveryOption'] = $this->normalizer->normalize($data->getServiceDeliveryOption(), 'json', $context);
        $dataArray['shouldGenerateInvoice'] = $data->getShouldGenerateInvoice();
        $dataArray['specificBillingAccount'] = $this->normalizer->normalize($data->getSpecificBillingAccount(), 'json', $context);
        $dataArray['specificVeterinaryGroup'] = $this->normalizer->normalize($data->getSpecificVeterinaryGroup(), 'json', $context);
        $dataArray['unitPriceWithoutVat'] = $data->getUnitPriceWithoutVat();
        $dataArray['unitPriceWithVat'] = $data->getUnitPriceWithVat();
        $dataArray['veterinaryEstablishment'] = $this->normalizer->normalize($data->getVeterinaryEstablishment(), 'json', $context);
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\VeterinaryEstablishmentServiceDeliveryResponse::class => false];
    }
}