<?php

namespace NoahVet\Reef\Bsm\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Bsm\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Bsm\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class PublisherUserInvitationRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\Reef\Bsm\Model\PublisherUserInvitationRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\Reef\Bsm\Model\PublisherUserInvitationRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Bsm\Model\PublisherUserInvitationRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('departments', $data)) {
            $values = [];
            foreach ($data['departments'] as $value) {
                $values[] = $value;
            }
            $object->setDepartments($values);
            unset($data['departments']);
        }
        if (\array_key_exists('emailTemplateNumber', $data)) {
            $object->setEmailTemplateNumber($data['emailTemplateNumber']);
            unset($data['emailTemplateNumber']);
        }
        if (\array_key_exists('entryDate', $data)) {
            $object->setEntryDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['entryDate']));
            unset($data['entryDate']);
        }
        if (\array_key_exists('expirationDate', $data) && $data['expirationDate'] !== null) {
            $object->setExpirationDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['expirationDate']));
            unset($data['expirationDate']);
        }
        elseif (\array_key_exists('expirationDate', $data) && $data['expirationDate'] === null) {
            $object->setExpirationDate(null);
        }
        if (\array_key_exists('exitDate', $data) && $data['exitDate'] !== null) {
            $object->setExitDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['exitDate']));
            unset($data['exitDate']);
        }
        elseif (\array_key_exists('exitDate', $data) && $data['exitDate'] === null) {
            $object->setExitDate(null);
        }
        if (\array_key_exists('invitedUser', $data)) {
            $object->setInvitedUser($this->denormalizer->denormalize($data['invitedUser'], \NoahVet\Reef\Bsm\Model\IdRequest::class, 'json', $context));
            unset($data['invitedUser']);
        }
        if (\array_key_exists('jobTitle', $data)) {
            $object->setJobTitle($data['jobTitle']);
            unset($data['jobTitle']);
        }
        if (\array_key_exists('publisher', $data)) {
            $object->setPublisher($this->denormalizer->denormalize($data['publisher'], \NoahVet\Reef\Bsm\Model\IdRequest::class, 'json', $context));
            unset($data['publisher']);
        }
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $values = [];
        foreach ($data->getDepartments() as $value) {
            $values[] = $value;
        }
        $dataArray['departments'] = $values;
        $dataArray['emailTemplateNumber'] = $data->getEmailTemplateNumber();
        $dataArray['entryDate'] = $data->getEntryDate()?->format('Y-m-d\\TH:i:sP');
        if ($data->isInitialized('expirationDate') && null !== $data->getExpirationDate()) {
            $dataArray['expirationDate'] = $data->getExpirationDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('exitDate') && null !== $data->getExitDate()) {
            $dataArray['exitDate'] = $data->getExitDate()->format('Y-m-d\\TH:i:sP');
        }
        $dataArray['invitedUser'] = $this->normalizer->normalize($data->getInvitedUser(), 'json', $context);
        $dataArray['jobTitle'] = $data->getJobTitle();
        $dataArray['publisher'] = $this->normalizer->normalize($data->getPublisher(), 'json', $context);
        foreach ($data as $key => $value_1) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\Reef\Bsm\Model\PublisherUserInvitationRequest::class => false];
    }
}